/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.storage.dbquery;

import java.util.Map;
import java.util.TreeMap;
import org.wikidata.wdtk.storage.dbquery.PairTrie;
import org.wikidata.wdtk.storage.dbquery.TrieIterable;
import org.wikidata.wdtk.storage.dbquery.TrieIterator;
import org.wikidata.wdtk.storage.dbquery.TripleTrieIterator;

public class TripleTrie
implements TrieIterable {
    TreeMap<Integer, PairTrie> levelOne = new TreeMap();
    int size = 0;

    public void insertTriple(int subject, int predicate, int object) {
        PairTrie pt = this.getPairTrie(subject);
        if (pt == null) {
            pt = new PairTrie();
            this.levelOne.put(subject, pt);
        }
        pt.insertPair(predicate, object);
        ++this.size;
    }

    protected PairTrie getPairTrie(int i) {
        return this.levelOne.get(i);
    }

    public void sortAll() {
        for (Map.Entry<Integer, PairTrie> entry : this.levelOne.entrySet()) {
            entry.getValue().sortAllPairs();
        }
    }

    public void printStatistics(boolean detailed) {
        System.out.println("Size of level 1: " + this.levelOne.size());
        int subjects = 0;
        int shortCount = 0;
        int intervalCount = 0;
        int intervalSize = 0;
        int longCount = 0;
        int longSize = 0;
        int longLength = 0;
        for (PairTrie pt : this.levelOne.values()) {
            subjects += pt.nodes.size();
            if (!detailed) continue;
            for (int[] pairs : pt.nodes) {
                if (pairs.length == 2) {
                    ++shortCount;
                    continue;
                }
                if (pairs.length == 3) {
                    ++intervalCount;
                    intervalSize += 1 + pairs[1] - pairs[0];
                    continue;
                }
                ++longCount;
                longSize += Math.abs(pairs[1]);
                longLength += pairs.length;
            }
        }
        System.out.println("Size of level 2: " + subjects);
        System.out.println("Encoded triples: " + this.size);
        if (detailed) {
            System.out.println("Short records: " + shortCount);
            System.out.println("Intervals: " + intervalCount + " with " + intervalSize + " triples");
            System.out.println("Long records: " + longCount + " with " + longSize + " triples, using " + longLength + " ints");
        }
    }

    public void printTuples() {
        for (Map.Entry<Integer, PairTrie> entry : this.levelOne.entrySet()) {
            for (int[] pairs : entry.getValue()) {
                if (pairs.length == 2) {
                    System.out.print(entry.getKey());
                    System.out.print(" ");
                    System.out.print(pairs[0]);
                    System.out.print(" ");
                    System.out.print(pairs[1]);
                    System.out.println();
                    continue;
                }
                if (pairs.length == 3) {
                    System.out.print(entry.getKey());
                    System.out.print(" ");
                    System.out.print(pairs[0]);
                    System.out.print("-");
                    System.out.print(pairs[1]);
                    System.out.print(" ");
                    System.out.print(pairs[2]);
                    System.out.println();
                    continue;
                }
                for (int i = 0; i < Math.abs(pairs[1]); ++i) {
                    System.out.print(entry.getKey());
                    System.out.print(" ");
                    System.out.print(pairs[0]);
                    System.out.print(" ");
                    System.out.print(pairs[2 + i]);
                    System.out.println();
                    if (i < 10 || i >= Math.abs(pairs[1]) - 2) continue;
                    System.out.println("... (" + (Math.abs(pairs[1]) - i - 1) + " further tuples)");
                    i = Math.abs(pairs[1]) - 2;
                }
            }
        }
    }

    @Override
    public TrieIterator getTrieIterator() {
        return new TripleTrieIterator(this);
    }
}

