/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.storage.dbquery;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;

class PairTrie
implements Iterable<int[]> {
    TreeSet<int[]> nodes = new TreeSet<int[]>(new FirstArrayElementComparator());
    boolean allSorted = true;

    public void insertPair(int a, int b) {
        int[] pairs = this.nodes.floor(new int[]{a});
        if (pairs == null) {
            this.nodes.add(new int[]{a, b});
            return;
        }
        if (pairs[0] == a && pairs.length == 2) {
            this.nodes.remove(pairs);
            this.nodes.add(this.getTwoValuePairs(a, pairs[1], b));
        } else if (pairs[0] == a && pairs.length > 3) {
            int size2 = Math.abs(pairs[1]);
            if (pairs.length == size2 + 2) {
                this.nodes.remove(pairs);
                int[] newpairs = Arrays.copyOf(pairs, size2 * 2);
                newpairs[1] = -size2 - 1;
                newpairs[size2 + 2] = b;
                this.nodes.add(newpairs);
            } else {
                pairs[1] = -size2 - 1;
                pairs[size2 + 2] = b;
            }
            this.allSorted = false;
        } else if (pairs.length == 3 && pairs[1] >= a) {
            if (pairs[2] == b) {
                return;
            }
            this.nodes.remove(pairs);
            this.nodes.add(this.getTwoValuePairs(a, pairs[2], b));
            this.addIntervalOrShortRecord(pairs[0], a - 1, pairs[2]);
            this.addIntervalOrShortRecord(a + 1, pairs[1], pairs[2]);
        } else if (pairs.length == 3 && pairs[1] == a - 1 && pairs[2] == b) {
            pairs[1] = a;
        } else if (pairs.length == 2 && pairs[0] == a - 1 && pairs[1] == b) {
            this.nodes.remove(pairs);
            this.nodes.add(new int[]{a - 1, a, b});
        } else {
            this.nodes.add(new int[]{a, b});
        }
    }

    private void addIntervalOrShortRecord(int start2, int end, int value) {
        if (start2 == end) {
            this.nodes.add(new int[]{start2, value});
        } else if (start2 < end) {
            this.nodes.add(new int[]{start2, end, value});
        }
    }

    private int[] getTwoValuePairs(int a, int c1, int c2) {
        if (c1 == c2) {
            return new int[]{a, c1};
        }
        int[] newpairs = new int[5];
        newpairs[0] = a;
        newpairs[1] = 2;
        if (c1 < c2) {
            newpairs[2] = c1;
            newpairs[3] = c2;
        } else {
            newpairs[2] = c2;
            newpairs[3] = c1;
        }
        return newpairs;
    }

    void sortAllPairs() {
        if (this.allSorted) {
            return;
        }
        for (int[] pairs : this.nodes) {
            this.sortPairs(pairs);
        }
        this.allSorted = true;
    }

    int[] sortPairs(int[] pairs) {
        if (pairs.length > 3 && pairs[1] < 0) {
            pairs[1] = Math.abs(pairs[1]);
            Arrays.sort(pairs, 2, pairs[1] + 2);
            int j = 2;
            for (int i = 3; i < pairs[1] + 2; ++i) {
                if (pairs[j] == pairs[i] || ++j >= i) continue;
                pairs[j] = pairs[i];
            }
            pairs[1] = j - 1;
        }
        return pairs;
    }

    @Override
    public Iterator<int[]> iterator() {
        return this.nodes.iterator();
    }

    class FirstArrayElementComparator
    implements Comparator<int[]> {
        FirstArrayElementComparator() {
        }

        @Override
        public int compare(int[] arg0, int[] arg1) {
            return arg0[0] > arg1[0] ? 1 : (arg1[0] > arg0[0] ? -1 : 0);
        }
    }
}

