/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.storage.datastructures;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.storage.datastructures.BitVector;

public class BitVectorIterator
implements Iterator<Boolean> {
    final BitVector bitVector;
    int pointer = 0;

    public BitVectorIterator(BitVector bitVector) {
        Validate.notNull(bitVector, "Bit vector cannot be null.", new Object[0]);
        this.bitVector = bitVector;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BitVectorIterator)) {
            return false;
        }
        BitVectorIterator other = (BitVectorIterator)o;
        return this.pointer == other.pointer && this.bitVector.equals(other.bitVector);
    }

    public int hashCode() {
        return this.pointer + 31 * this.bitVector.hashCode();
    }

    @Override
    public boolean hasNext() {
        return (long)this.pointer < this.bitVector.size();
    }

    @Override
    public Boolean next() {
        if ((long)this.pointer >= this.bitVector.size()) {
            throw new NoSuchElementException();
        }
        return this.bitVector.getBit(this.pointer++);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

