/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.dumpfiles.wmf;

import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.dumpfiles.DumpContentType;
import org.wikidata.wdtk.dumpfiles.wmf.WmfDumpFile;
import org.wikidata.wdtk.util.DirectoryManager;
import org.wikidata.wdtk.util.WebResourceFetcher;

public class JsonOnlineDumpFile
extends WmfDumpFile {
    static final Logger logger = LoggerFactory.getLogger(JsonOnlineDumpFile.class);
    final WebResourceFetcher webResourceFetcher;
    final DirectoryManager dumpfileDirectoryManager;
    private boolean isPrepared;

    public JsonOnlineDumpFile(String dateStamp, String projectName, WebResourceFetcher webResourceFetcher, DirectoryManager dumpfileDirectoryManager) {
        super(dateStamp, projectName);
        this.webResourceFetcher = webResourceFetcher;
        this.dumpfileDirectoryManager = dumpfileDirectoryManager;
    }

    @Override
    public DumpContentType getDumpContentType() {
        return DumpContentType.JSON;
    }

    @Override
    public InputStream getDumpFileStream() throws IOException {
        this.prepareDumpFile();
        String fileName = WmfDumpFile.getDumpFileName(DumpContentType.JSON, this.projectName, this.dateStamp);
        DirectoryManager dailyDirectoryManager = this.dumpfileDirectoryManager.getSubdirectoryManager(WmfDumpFile.getDumpFileDirectoryName(DumpContentType.JSON, this.dateStamp));
        return dailyDirectoryManager.getInputStreamForFile(fileName, WmfDumpFile.getDumpFileCompressionType(DumpContentType.JSON));
    }

    @Override
    public void prepareDumpFile() throws IOException {
        if (this.isPrepared) {
            return;
        }
        String fileName = WmfDumpFile.getDumpFileName(DumpContentType.JSON, this.projectName, this.dateStamp);
        String urlString = this.getBaseUrl() + fileName;
        logger.info("Downloading JSON dump file " + fileName + " from " + urlString + " ...");
        if (!this.isAvailable()) {
            throw new IOException("Dump file not available (yet). Aborting dump retrieval.");
        }
        DirectoryManager dailyDirectoryManager = this.dumpfileDirectoryManager.getSubdirectoryManager(WmfDumpFile.getDumpFileDirectoryName(DumpContentType.JSON, this.dateStamp));
        try (InputStream inputStream2 = this.webResourceFetcher.getInputStreamForUrl(urlString);){
            dailyDirectoryManager.createFileAtomic(fileName, inputStream2);
        }
        this.isPrepared = true;
        logger.info("... completed download of JSON dump file " + fileName + " from " + urlString);
    }

    @Override
    protected boolean fetchIsDone() {
        return true;
    }

    String getBaseUrl() {
        return WmfDumpFile.getDumpFileWebDirectory(DumpContentType.JSON, this.projectName);
    }
}

