/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.dumpfiles.constraint.template;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TemplateScanner {
    public List<String> getTemplates(String text2) {
        return Collections.unmodifiableList(this.extractTemplates(this.removeHTMLComments(text2)));
    }

    List<String> extractTemplates(String text2) {
        ArrayList<String> ret = new ArrayList<String>();
        int pos = 0;
        int level = 0;
        int lastBegin = 0;
        boolean nowiki = false;
        while (pos != -1) {
            int nextClosingBraces = text2.indexOf("}}", pos);
            if (nextClosingBraces == -1) {
                pos = -1;
                continue;
            }
            if (nowiki) {
                int nextClosingNowiki = text2.indexOf("</nowiki>", pos);
                if (nextClosingNowiki == -1) {
                    pos = -1;
                    continue;
                }
                pos = nextClosingNowiki + "</nowiki>".length();
                nowiki = false;
                continue;
            }
            int nextOpeningBraces = text2.indexOf("{{", pos);
            int nextOpeningNowiki = text2.indexOf("<nowiki>", pos);
            if (nextOpeningNowiki != -1 && nextOpeningNowiki < nextOpeningBraces) {
                pos = nextOpeningNowiki + "<nowiki>".length();
                nowiki = true;
                continue;
            }
            if (nextOpeningBraces != -1 && nextOpeningBraces < nextClosingBraces) {
                pos = nextOpeningBraces + "{{".length();
                if (level == 0) {
                    lastBegin = nextOpeningBraces;
                }
                ++level;
                continue;
            }
            if (--level == 0) {
                ret.add(text2.substring(lastBegin, nextClosingBraces + "}}".length()));
            }
            pos = nextClosingBraces + "}}".length();
        }
        return ret;
    }

    String removeHTMLComments(String text2) {
        return text2.replaceAll("(?s)<!--.*?-->", "");
    }
}

