/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.dumpfiles.constraint.template;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.dumpfiles.constraint.template.Template;

public class TemplateParser {
    private LookAhead findItem(String str, int pos, boolean nowiki) {
        TreeSet<LookAhead> set = new TreeSet<LookAhead>();
        set.add(this.findItem(str, LookAheadItem.OPENING_NOWIKI, pos));
        set.add(this.findItem(str, LookAheadItem.CLOSING_NOWIKI, pos));
        if (!nowiki) {
            set.add(this.findItem(str, LookAheadItem.OPENING_BRACES, pos));
            set.add(this.findItem(str, LookAheadItem.CLOSING_BRACES, pos));
            set.add(this.findItem(str, LookAheadItem.VERTICAL_BAR, pos));
        }
        return (LookAhead)set.iterator().next();
    }

    private LookAhead findItem(String str, LookAheadItem item, int pos) {
        int nextPos;
        LookAhead ret = new LookAhead();
        if (!item.equals((Object)LookAheadItem.UNDEFINED) && (nextPos = str.indexOf(this.getString(item), pos)) != -1) {
            ret = new LookAhead(nextPos, item);
        }
        return ret;
    }

    private String getKey(String parameter) {
        String ret = parameter;
        int pos = parameter.indexOf("=");
        if (pos != -1) {
            ret = parameter.substring(0, pos);
        }
        return ret;
    }

    private List<String> getParameterList(String str) {
        ArrayList<String> ret = new ArrayList<String>();
        boolean nowiki = false;
        LookAhead nextItem = this.findItem(str, 0, nowiki);
        int level = 0;
        int lastPos = 0;
        while (!nextItem.item.equals((Object)LookAheadItem.UNDEFINED)) {
            if (nextItem.item.equals((Object)LookAheadItem.OPENING_BRACES)) {
                ++level;
            } else if (nextItem.item.equals((Object)LookAheadItem.CLOSING_BRACES)) {
                --level;
            } else if (nextItem.item.equals((Object)LookAheadItem.OPENING_NOWIKI)) {
                nowiki = true;
            } else if (nextItem.item.equals((Object)LookAheadItem.CLOSING_NOWIKI)) {
                nowiki = false;
            } else if (nextItem.item.equals((Object)LookAheadItem.VERTICAL_BAR) && level == 0) {
                ret.add(str.substring(lastPos, nextItem.position));
                lastPos = nextItem.position + this.getString(nextItem.item).length();
            }
            nextItem = this.findItem(str, nextItem.position + this.getString(nextItem.item).length(), nowiki);
        }
        ret.add(str.substring(lastPos));
        return ret;
    }

    private Map<String, String> getParameterMap(List<String> list) {
        TreeMap<String, String> ret = new TreeMap<String, String>();
        for (String line : list) {
            String key = this.getKey(line);
            String value = this.getValue(line);
            if (key.trim().isEmpty()) continue;
            ret.put(key, value);
        }
        return ret;
    }

    private String getValue(String parameter) {
        String ret = "";
        int pos = parameter.indexOf("=");
        if (pos != -1) {
            ret = parameter.substring(pos + "=".length());
        }
        return ret;
    }

    private String getString(LookAheadItem item) {
        if (item.equals((Object)LookAheadItem.OPENING_BRACES)) {
            return "{{";
        }
        if (item.equals((Object)LookAheadItem.CLOSING_BRACES)) {
            return "}}";
        }
        if (item.equals((Object)LookAheadItem.OPENING_NOWIKI)) {
            return "<nowiki>";
        }
        if (item.equals((Object)LookAheadItem.CLOSING_NOWIKI)) {
            return "</nowiki>";
        }
        if (item.equals((Object)LookAheadItem.VERTICAL_BAR)) {
            return "|";
        }
        return "";
    }

    public Template parse(String line) {
        Validate.notNull(line, "Line cannot be null.", new Object[0]);
        if (!line.startsWith("{{") || !line.endsWith("}}")) {
            throw new IllegalArgumentException("This string is not a valid template: '" + line + "'. The line must start with \"" + "{{" + "\" and end with \"" + "}}" + "\".");
        }
        String id = "";
        String str = line.substring("{{".length(), line.length() - "}}".length());
        List<String> list = this.getParameterList(str);
        if (list.size() > 0) {
            id = list.get(0);
            list.remove(0);
        }
        Map<String, String> parameters = this.getParameterMap(list);
        return new Template(id, parameters);
    }

    static enum LookAheadItem {
        UNDEFINED,
        OPENING_BRACES,
        CLOSING_BRACES,
        OPENING_NOWIKI,
        CLOSING_NOWIKI,
        VERTICAL_BAR;

    }

    class LookAhead
    implements Comparable<LookAhead> {
        LookAheadItem item = LookAheadItem.UNDEFINED;
        int position = -1;

        LookAhead() {
        }

        LookAhead(int position, LookAheadItem item) {
            this.position = position;
            this.item = item;
        }

        @Override
        public int compareTo(LookAhead other) {
            if (this.position == other.position && this.item.equals((Object)other.item)) {
                return 0;
            }
            if (this.position == -1) {
                if (other.position == -1) {
                    return 0;
                }
                return 1;
            }
            if (other.position == -1) {
                return -1;
            }
            return this.position - other.position;
        }

        public String toString() {
            return "" + this.item.toString() + "@" + this.position;
        }
    }
}

