/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.dumpfiles;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.datamodel.implementation.SitesImpl;
import org.wikidata.wdtk.datamodel.interfaces.Sites;
import org.wikidata.wdtk.dumpfiles.MwDumpFile;
import org.wikidata.wdtk.dumpfiles.MwDumpFileProcessor;

public class MwSitesDumpFileProcessor
implements MwDumpFileProcessor {
    static final Logger logger = LoggerFactory.getLogger(MwSitesDumpFileProcessor.class);
    final SitesImpl sites = new SitesImpl();

    public Sites getSites() {
        return this.sites;
    }

    @Override
    public void processDumpFileContents(InputStream inputStream2, MwDumpFile dumpFile) {
        logger.info("Processing sites dump file " + dumpFile.toString());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream2));
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                if (!line.startsWith("INSERT INTO `sites` VALUES")) continue;
                Matcher matcher = Pattern.compile("[(][^)]*[)]").matcher(line.substring(27, line.length() - 1));
                while (matcher.find()) {
                    this.processSiteRow(matcher.group());
                }
                break;
            }
        }
        catch (IOException e) {
            logger.error("IO Error when processing dump of sites table: " + e.toString());
        }
    }

    void processSiteRow(String siteRow) {
        String[] row = this.getSiteRowFields(siteRow);
        String filePath = "";
        String pagePath = "";
        String dataArray = row[8].substring(row[8].indexOf(123), row[8].length() - 2);
        Matcher matcher = Pattern.compile("[{;](([^;}{][^;}{]*)|[}])").matcher(dataArray);
        String prevString = "";
        String curString = "";
        String path = "";
        boolean valuePosition = false;
        while (matcher.find()) {
            String match = matcher.group().substring(1);
            if (match.length() == 0) {
                valuePosition = false;
                continue;
            }
            if (match.charAt(0) == 's') {
                valuePosition = !valuePosition && !"".equals(prevString);
                curString = match.substring(match.indexOf(34) + 1, match.length() - 2);
            } else if (match.charAt(0) == 'a') {
                valuePosition = false;
                path = path + "/" + prevString;
            } else if ("}".equals(match)) {
                valuePosition = false;
                path = path.substring(0, path.lastIndexOf(47));
            }
            if (valuePosition && "file_path".equals(prevString) && "/paths".equals(path)) {
                filePath = curString;
            } else if (valuePosition && "page_path".equals(prevString) && "/paths".equals(path)) {
                pagePath = curString;
            }
            prevString = curString;
            curString = "";
        }
        logger.debug("Found site data \"" + row[1] + "\" (group \"" + row[3] + "\", language \"" + row[5] + "\", type \"" + row[2] + "\")");
        this.sites.setSiteInformation(row[1], row[3], row[5], row[2], "http:" + filePath, "http:" + pagePath);
    }

    String[] getSiteRowFields(String siteRow) {
        String[] siteRowFields = new String[11];
        Matcher matcher = Pattern.compile("[(,](['][^']*[']|[^'][^),]*)").matcher(siteRow);
        int columnIndex = 0;
        while (matcher.find()) {
            String field2 = matcher.group().substring(1);
            if (field2.charAt(0) == '\'') {
                field2 = field2.substring(1, field2.length() - 1);
            }
            siteRowFields[columnIndex] = field2;
            ++columnIndex;
        }
        return siteRowFields;
    }
}

