/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.dumpfiles;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.datamodel.interfaces.EntityDocumentDumpProcessor;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;
import org.wikidata.wdtk.util.Timer;

public class EntityTimerProcessor
implements EntityDocumentDumpProcessor {
    static final Logger logger = LoggerFactory.getLogger(EntityTimerProcessor.class);
    final Timer timer = Timer.getNamedTimer("EntityTimerProcessor");
    final int timeout;
    int entityCount = 0;
    int lastSeconds = 0;

    public EntityTimerProcessor(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public void processItemDocument(ItemDocument itemDocument) {
        this.countEntity();
    }

    @Override
    public void processPropertyDocument(PropertyDocument propertyDocument) {
        this.countEntity();
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
        logger.info("Finished processing.");
        this.timer.stop();
        this.lastSeconds = (int)(this.timer.getTotalWallTime() / 1000000000L);
        this.printStatus();
    }

    private void countEntity() {
        if (!this.timer.isRunning()) {
            this.startTimer();
        }
        ++this.entityCount;
        if (this.entityCount % 100 == 0) {
            this.timer.stop();
            int seconds = (int)(this.timer.getTotalWallTime() / 1000000000L);
            if (seconds >= this.lastSeconds + 10) {
                this.lastSeconds = seconds;
                this.printStatus();
                if (this.timeout > 0 && seconds > this.timeout) {
                    logger.info("Timeout. Aborting processing.");
                    throw new TimeoutException();
                }
            }
            this.timer.start();
        }
    }

    private void printStatus() {
        logger.info("Processed " + this.entityCount + " entities in " + this.lastSeconds + " sec" + (this.lastSeconds > 0 ? " (" + this.entityCount / this.lastSeconds + " per second)" : ""));
    }

    private void startTimer() {
        logger.info("Starting processing.");
        this.timer.start();
    }

    public class TimeoutException
    extends RuntimeException {
        private static final long serialVersionUID = -1083533602730765194L;
    }
}

