/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.json.jackson;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wikidata.wdtk.datamodel.helpers.Datamodel;
import org.wikidata.wdtk.datamodel.helpers.DatamodelConverter;
import org.wikidata.wdtk.datamodel.interfaces.Claim;
import org.wikidata.wdtk.datamodel.interfaces.DataObjectFactory;
import org.wikidata.wdtk.datamodel.interfaces.DatatypeIdValue;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.GlobeCoordinatesValue;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.ItemIdValue;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.NoValueSnak;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.QuantityValue;
import org.wikidata.wdtk.datamodel.interfaces.Reference;
import org.wikidata.wdtk.datamodel.interfaces.SiteLink;
import org.wikidata.wdtk.datamodel.interfaces.Snak;
import org.wikidata.wdtk.datamodel.interfaces.SnakGroup;
import org.wikidata.wdtk.datamodel.interfaces.SomeValueSnak;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;
import org.wikidata.wdtk.datamodel.interfaces.StatementRank;
import org.wikidata.wdtk.datamodel.interfaces.StringValue;
import org.wikidata.wdtk.datamodel.interfaces.TimeValue;
import org.wikidata.wdtk.datamodel.interfaces.Value;
import org.wikidata.wdtk.datamodel.interfaces.ValueSnak;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonItemDocument;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonMonolingualTextValue;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonNoValueSnak;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonPropertyDocument;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonReference;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonSiteLink;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonSnak;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonSomeValueSnak;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonStatement;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonTermedStatementDocument;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonValueSnak;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonInnerEntityId;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonInnerGlobeCoordinates;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonInnerMonolingualText;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonInnerQuantity;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonInnerTime;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonValue;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonValueGlobeCoordinates;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonValueItemId;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonValueMonolingualText;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonValuePropertyId;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonValueQuantity;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonValueString;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonValueTime;

public class JacksonObjectFactory
implements DataObjectFactory {
    private final DatamodelConverter dataModelConverter = new DatamodelConverter(this);

    @Override
    public ItemIdValue getItemIdValue(String id, String siteIri) {
        if (id.length() > 0 && id.charAt(0) == 'Q') {
            Integer numericId = Integer.valueOf(id.substring(1));
            JacksonInnerEntityId innerEntity = new JacksonInnerEntityId("item", numericId);
            JacksonValueItemId result2 = new JacksonValueItemId();
            result2.setValue(innerEntity);
            result2.setSiteIri(siteIri);
            return result2;
        }
        throw new IllegalArgumentException("Illegal item id: " + id);
    }

    @Override
    public PropertyIdValue getPropertyIdValue(String id, String siteIri) {
        if (id.length() > 0 && id.charAt(0) == 'P') {
            Integer numericId = Integer.valueOf(id.substring(1));
            JacksonInnerEntityId innerEntity = new JacksonInnerEntityId("property", numericId);
            JacksonValuePropertyId result2 = new JacksonValuePropertyId();
            result2.setValue(innerEntity);
            result2.setSiteIri(siteIri);
            return result2;
        }
        throw new IllegalArgumentException("Illegal property id: " + id);
    }

    @Override
    public DatatypeIdValue getDatatypeIdValue(String id) {
        return Datamodel.makeDatatypeIdValue(id);
    }

    @Override
    public TimeValue getTimeValue(long year, byte month, byte day, byte hour, byte minute, byte second, byte precision, int beforeTolerance, int afterTolerance, int timezoneOffset, String calendarModel) {
        JacksonInnerTime innerTime = new JacksonInnerTime(year, month, day, hour, minute, second, timezoneOffset, beforeTolerance, afterTolerance, precision, calendarModel);
        JacksonValueTime result2 = new JacksonValueTime();
        result2.setValue(innerTime);
        return result2;
    }

    @Override
    public GlobeCoordinatesValue getGlobeCoordinatesValue(double latitude, double longitude, double precision, String globeIri) {
        if (precision <= 0.0) {
            throw new IllegalArgumentException("Coordinates precision must be non-zero positive. Given value: " + precision);
        }
        JacksonInnerGlobeCoordinates innerCoordinates = new JacksonInnerGlobeCoordinates();
        innerCoordinates.setLatitude(latitude);
        innerCoordinates.setLongitude(longitude);
        innerCoordinates.setPrecision(precision);
        innerCoordinates.setGlobe(globeIri);
        JacksonValueGlobeCoordinates result2 = new JacksonValueGlobeCoordinates();
        result2.setValue(innerCoordinates);
        return result2;
    }

    @Override
    public StringValue getStringValue(String string2) {
        JacksonValueString result2 = new JacksonValueString();
        result2.setValue(string2);
        return result2;
    }

    @Override
    public MonolingualTextValue getMonolingualTextValue(String text2, String languageCode) {
        JacksonInnerMonolingualText innerMtlv = new JacksonInnerMonolingualText(languageCode, text2);
        JacksonValueMonolingualText result2 = new JacksonValueMonolingualText();
        result2.setValue(innerMtlv);
        return result2;
    }

    @Override
    public QuantityValue getQuantityValue(BigDecimal numericValue, BigDecimal lowerBound, BigDecimal upperBound) {
        JacksonInnerQuantity innerQuantity = new JacksonInnerQuantity(numericValue, upperBound, lowerBound);
        JacksonValueQuantity result2 = new JacksonValueQuantity();
        result2.setValue(innerQuantity);
        return result2;
    }

    @Override
    public ValueSnak getValueSnak(PropertyIdValue propertyId, Value value) {
        JacksonValueSnak result2 = new JacksonValueSnak();
        result2.setProperty(propertyId.getId());
        if (value instanceof JacksonValue) {
            return this.getJacksonValueSnak(propertyId, (JacksonValue)value, this.getJsonPropertyTypeForValueType(value));
        }
        return this.getJacksonValueSnak(propertyId, (JacksonValue)this.dataModelConverter.copyValue(value), this.getJsonPropertyTypeForValueType(value));
    }

    @Override
    public SomeValueSnak getSomeValueSnak(PropertyIdValue propertyId) {
        JacksonSomeValueSnak result2 = new JacksonSomeValueSnak();
        result2.setProperty(propertyId.getId());
        result2.setSiteIri(propertyId.getSiteIri());
        return result2;
    }

    @Override
    public NoValueSnak getNoValueSnak(PropertyIdValue propertyId) {
        JacksonNoValueSnak result2 = new JacksonNoValueSnak();
        result2.setProperty(propertyId.getId());
        result2.setSiteIri(propertyId.getSiteIri());
        return result2;
    }

    @Override
    public SnakGroup getSnakGroup(List<? extends Snak> snaks) {
        return Datamodel.makeSnakGroup(this.convertSnakList(snaks));
    }

    @Override
    public Claim getClaim(EntityIdValue subject, Snak mainSnak, List<SnakGroup> qualifiers) {
        Statement statement = this.getStatement(Datamodel.makeClaim(subject, mainSnak, qualifiers), Collections.emptyList(), StatementRank.NORMAL, "empty id 12345");
        return statement.getClaim();
    }

    @Override
    public Reference getReference(List<SnakGroup> snakGroups) {
        JacksonReference result2 = new JacksonReference();
        HashMap<String, List<JacksonSnak>> snakMap = new HashMap<String, List<JacksonSnak>>();
        ArrayList<String> propertyOrder = new ArrayList<String>(snakGroups.size());
        for (SnakGroup snakGroup : snakGroups) {
            snakMap.put(snakGroup.getProperty().getId(), this.convertSnakList(snakGroup.getSnaks()));
            propertyOrder.add(snakGroup.getProperty().getId());
        }
        result2.setSnaks(snakMap);
        result2.setPropertyOrder(propertyOrder);
        return result2;
    }

    @Override
    public Statement getStatement(Claim claim, List<? extends Reference> references, StatementRank rank, String statementId) {
        JacksonStatement result2 = new JacksonStatement();
        if (claim.getMainSnak() instanceof JacksonSnak) {
            result2.setMainsnak((JacksonSnak)claim.getMainSnak());
        } else {
            result2.setMainsnak((JacksonSnak)this.dataModelConverter.copySnak(claim.getMainSnak()));
        }
        HashMap<String, List<JacksonSnak>> qualifiers = new HashMap<String, List<JacksonSnak>>();
        ArrayList<String> propertyOrder = new ArrayList<String>(claim.getQualifiers().size());
        for (SnakGroup sg : claim.getQualifiers()) {
            qualifiers.put(sg.getProperty().getId(), this.convertSnakList(sg.getSnaks()));
            propertyOrder.add(sg.getProperty().getId());
        }
        result2.setQualifiers(qualifiers);
        result2.setPropertyOrder(propertyOrder);
        ArrayList<JacksonReference> jacksonReferences = new ArrayList<JacksonReference>(references.size());
        for (Reference reference : references) {
            if (reference instanceof JacksonReference) {
                jacksonReferences.add((JacksonReference)reference);
                continue;
            }
            jacksonReferences.add((JacksonReference)this.dataModelConverter.copy(reference));
        }
        result2.setReferences(jacksonReferences);
        result2.setRank(rank);
        result2.setStatementId(statementId);
        result2.setSubject(claim.getSubject());
        return result2;
    }

    @Override
    public StatementGroup getStatementGroup(List<Statement> statements) {
        ArrayList<Statement> newStatements = new ArrayList<Statement>(statements.size());
        for (Statement statement : statements) {
            if (statement instanceof JacksonStatement) {
                newStatements.add(statement);
                continue;
            }
            newStatements.add(this.dataModelConverter.copy(statement));
        }
        return Datamodel.makeStatementGroup(statements);
    }

    @Override
    public SiteLink getSiteLink(String title, String siteKey, List<String> badges) {
        JacksonSiteLink result2 = new JacksonSiteLink();
        result2.setPageTitle(title);
        result2.setSiteKey(siteKey);
        result2.setBadges(badges);
        return result2;
    }

    @Override
    public PropertyDocument getPropertyDocument(PropertyIdValue propertyId, List<MonolingualTextValue> labels, List<MonolingualTextValue> descriptions, List<MonolingualTextValue> aliases, DatatypeIdValue datatypeId) {
        return this.getPropertyDocument(propertyId, labels, descriptions, aliases, Collections.emptyList(), datatypeId);
    }

    @Override
    public PropertyDocument getPropertyDocument(PropertyIdValue propertyId, List<MonolingualTextValue> labels, List<MonolingualTextValue> descriptions, List<MonolingualTextValue> aliases, List<StatementGroup> statementGroups, DatatypeIdValue datatypeId) {
        JacksonPropertyDocument result2 = new JacksonPropertyDocument();
        this.initializeTermedStatementDocument(result2, propertyId, labels, descriptions, aliases, statementGroups);
        switch (datatypeId.getIri()) {
            case "http://www.wikidata.org/ontology#propertyTypeItem": {
                result2.setJsonDatatype("wikibase-item");
                break;
            }
            case "http://www.wikidata.org/ontology#propertyTypeGlobeCoordinates": {
                result2.setJsonDatatype("globe-coordinate");
                break;
            }
            case "http://www.wikidata.org/ontology#propertyTypeUrl": {
                result2.setJsonDatatype("url");
                break;
            }
            case "http://www.wikidata.org/ontology#propertyTypeCommonsMedia": {
                result2.setJsonDatatype("commonsMedia");
                break;
            }
            case "http://www.wikidata.org/ontology#propertyTypeTime": {
                result2.setJsonDatatype("time");
                break;
            }
            case "http://www.wikidata.org/ontology#propertyTypeQuantity": {
                result2.setJsonDatatype("quantity");
                break;
            }
            case "http://www.wikidata.org/ontology#propertyTypeString": {
                result2.setJsonDatatype("string");
                break;
            }
            case "http://www.wikidata.org/ontology#propertyTypeMonolingualText": {
                result2.setJsonDatatype("monolingualtext");
                break;
            }
            case "http://www.wikidata.org/ontology#propertyTypeProperty": {
                result2.setJsonDatatype("wikibase-property");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown datatype: " + datatypeId.getIri());
            }
        }
        return result2;
    }

    @Override
    public ItemDocument getItemDocument(ItemIdValue itemIdValue, List<MonolingualTextValue> labels, List<MonolingualTextValue> descriptions, List<MonolingualTextValue> aliases, List<StatementGroup> statementGroups, Map<String, SiteLink> siteLinks) {
        JacksonItemDocument result2 = new JacksonItemDocument();
        this.initializeTermedStatementDocument(result2, itemIdValue, labels, descriptions, aliases, statementGroups);
        HashMap<String, JacksonSiteLink> jacksonSiteLinks = new HashMap<String, JacksonSiteLink>(siteLinks.size());
        for (SiteLink siteLink : siteLinks.values()) {
            if (siteLink instanceof JacksonSiteLink) {
                jacksonSiteLinks.put(siteLink.getSiteKey(), (JacksonSiteLink)siteLink);
                continue;
            }
            jacksonSiteLinks.put(siteLink.getSiteKey(), (JacksonSiteLink)this.dataModelConverter.copy(siteLink));
        }
        result2.setSiteLinks(jacksonSiteLinks);
        return result2;
    }

    private void initializeTermedStatementDocument(JacksonTermedStatementDocument document2, EntityIdValue entityIdValue, List<MonolingualTextValue> labels, List<MonolingualTextValue> descriptions, List<MonolingualTextValue> aliases, List<StatementGroup> statementGroups) {
        document2.setJsonId(entityIdValue.getId());
        document2.setSiteIri(entityIdValue.getSiteIri());
        HashMap<String, List<JacksonMonolingualTextValue>> aliasMap = new HashMap<String, List<JacksonMonolingualTextValue>>();
        for (MonolingualTextValue mltv : aliases) {
            ArrayList<JacksonMonolingualTextValue> langAliases = (ArrayList<JacksonMonolingualTextValue>)aliasMap.get(mltv.getLanguageCode());
            if (langAliases == null) {
                langAliases = new ArrayList<JacksonMonolingualTextValue>();
                aliasMap.put(mltv.getLanguageCode(), langAliases);
            }
            langAliases.add(this.convertMltv(mltv));
        }
        document2.setAliases(aliasMap);
        document2.setLabels(this.buildTermMapFromTermList(labels));
        document2.setDescriptions(this.buildTermMapFromTermList(descriptions));
        HashMap<String, List<JacksonStatement>> jacksonStatements = new HashMap<String, List<JacksonStatement>>();
        for (StatementGroup sg : statementGroups) {
            String propertyId = sg.getProperty().getId();
            ArrayList<JacksonStatement> propertyStatements = new ArrayList<JacksonStatement>(sg.getStatements().size());
            jacksonStatements.put(propertyId, propertyStatements);
            for (Statement s2 : sg) {
                if (s2 instanceof JacksonStatement) {
                    propertyStatements.add((JacksonStatement)s2);
                    continue;
                }
                propertyStatements.add((JacksonStatement)this.dataModelConverter.copy(s2));
            }
        }
        document2.setJsonClaims(jacksonStatements);
    }

    private Map<String, JacksonMonolingualTextValue> buildTermMapFromTermList(List<MonolingualTextValue> terms) {
        HashMap<String, JacksonMonolingualTextValue> result2 = new HashMap<String, JacksonMonolingualTextValue>(terms.size());
        for (MonolingualTextValue mltv : terms) {
            result2.put(mltv.getLanguageCode(), this.convertMltv(mltv));
        }
        return result2;
    }

    private JacksonMonolingualTextValue convertMltv(MonolingualTextValue mltv) {
        if (mltv instanceof JacksonMonolingualTextValue) {
            return (JacksonMonolingualTextValue)mltv;
        }
        return new JacksonMonolingualTextValue(mltv);
    }

    private ValueSnak getJacksonValueSnak(PropertyIdValue propertyId, JacksonValue value, String propertyDatatype) {
        JacksonValueSnak result2 = new JacksonValueSnak();
        result2.setProperty(propertyId.getId());
        result2.setDatavalue(value);
        result2.setDatatype(propertyDatatype);
        result2.setSiteIri(propertyId.getSiteIri());
        return result2;
    }

    private String getJsonPropertyTypeForValueType(Value value) {
        if (value instanceof TimeValue) {
            return "time";
        }
        if (value instanceof ItemIdValue) {
            return "wikibase-item";
        }
        if (value instanceof PropertyIdValue) {
            return "wikibase-property";
        }
        if (value instanceof StringValue) {
            return null;
        }
        if (value instanceof GlobeCoordinatesValue) {
            return "globe-coordinate";
        }
        if (value instanceof QuantityValue) {
            return "quantity";
        }
        if (value instanceof MonolingualTextValue) {
            return "monolingualtext";
        }
        throw new UnsupportedOperationException("Unsupported value type " + value.getClass());
    }

    private List<JacksonSnak> convertSnakList(List<? extends Snak> snaks) {
        ArrayList<JacksonSnak> result2 = new ArrayList<JacksonSnak>(snaks.size());
        for (Snak snak : snaks) {
            if (snak instanceof JacksonSnak) {
                result2.add((JacksonSnak)snak);
                continue;
            }
            result2.add((JacksonSnak)this.dataModelConverter.copySnak(snak));
        }
        return result2;
    }
}

