/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.json.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonMonolingualTextValue;

public class AliasesDeserializer
extends JsonDeserializer<Map<String, List<JacksonMonolingualTextValue>>> {
    @Override
    public Map<String, List<JacksonMonolingualTextValue>> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        HashMap<String, List<JacksonMonolingualTextValue>> contents = new HashMap<String, List<JacksonMonolingualTextValue>>();
        try {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            if (!node.isArray()) {
                Iterator<Map.Entry<String, JsonNode>> nodeIterator = node.fields();
                while (nodeIterator.hasNext()) {
                    ArrayList<JacksonMonolingualTextValue> mltvList = new ArrayList<JacksonMonolingualTextValue>();
                    Map.Entry<String, JsonNode> currentNode = nodeIterator.next();
                    for (JsonNode mltvEntry : currentNode.getValue()) {
                        String language2 = mltvEntry.get("language").asText();
                        String value = mltvEntry.get("value").asText();
                        mltvList.add(new JacksonMonolingualTextValue(language2, value));
                    }
                    contents.put(currentNode.getKey(), mltvList);
                }
            }
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return contents;
    }
}

