/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.interfaces;

import java.util.Set;
import org.wikidata.wdtk.datamodel.helpers.DatamodelConverter;
import org.wikidata.wdtk.datamodel.implementation.DataObjectFactoryImpl;
import org.wikidata.wdtk.datamodel.interfaces.EntityDocumentProcessor;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;

public class EntityDocumentProcessorFilter
implements EntityDocumentProcessor {
    final DatamodelConverter converter = new DatamodelConverter(new DataObjectFactoryImpl());
    final EntityDocumentProcessor entityDocumentProcessor;

    public EntityDocumentProcessorFilter(EntityDocumentProcessor entityDocumentProcessor) {
        this.entityDocumentProcessor = entityDocumentProcessor;
    }

    public void setPropertyFilter(Set<PropertyIdValue> propertyFilter) {
        this.converter.setOptionPropertyFilter(propertyFilter);
    }

    public void setSiteLinkFilter(Set<String> siteLinkFilter) {
        this.converter.setOptionSiteLinkFilter(siteLinkFilter);
    }

    public void setLanguageFilter(Set<String> languageFilter) {
        this.converter.setOptionLanguageFilter(languageFilter);
    }

    @Override
    public void processItemDocument(ItemDocument itemDocument) {
        itemDocument = this.converter.copy(itemDocument);
        this.entityDocumentProcessor.processItemDocument(itemDocument);
    }

    @Override
    public void processPropertyDocument(PropertyDocument propertyDocument) {
        propertyDocument = this.converter.copy(propertyDocument);
        this.entityDocumentProcessor.processPropertyDocument(propertyDocument);
    }
}

