/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementDocument;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;
import org.wikidata.wdtk.datamodel.interfaces.TermedDocument;
import org.wikidata.wdtk.util.NestedIterator;

public abstract class TermedStatementDocumentImpl
implements TermedDocument,
StatementDocument,
Serializable {
    private static final long serialVersionUID = 821881839755909320L;
    final Map<String, MonolingualTextValue> labels;
    final Map<String, MonolingualTextValue> descriptions;
    final Map<String, List<MonolingualTextValue>> aliases;
    final List<StatementGroup> statementGroups;

    TermedStatementDocumentImpl(EntityIdValue entityIdValue, List<MonolingualTextValue> labels, List<MonolingualTextValue> descriptions, List<MonolingualTextValue> aliases, List<StatementGroup> statementGroups) {
        Validate.notNull(labels, "list of labels cannot be null", new Object[0]);
        Validate.notNull(descriptions, "list of descriptions cannot be null", new Object[0]);
        Validate.notNull(aliases, "list of aliases cannot be null", new Object[0]);
        Validate.notNull(statementGroups, "statement list cannot be null", new Object[0]);
        this.labels = new HashMap<String, MonolingualTextValue>();
        for (MonolingualTextValue label : labels) {
            if (this.labels.containsKey(label.getLanguageCode())) {
                throw new IllegalArgumentException("At most one label allowed per language code");
            }
            this.labels.put(label.getLanguageCode(), label);
        }
        this.descriptions = new HashMap<String, MonolingualTextValue>();
        for (MonolingualTextValue description : descriptions) {
            if (this.descriptions.containsKey(description.getLanguageCode())) {
                throw new IllegalArgumentException("At most one description allowed per language code");
            }
            this.descriptions.put(description.getLanguageCode(), description);
        }
        this.aliases = new HashMap<String, List<MonolingualTextValue>>();
        for (MonolingualTextValue alias : aliases) {
            if (this.aliases.containsKey(alias.getLanguageCode())) {
                this.aliases.get(alias.getLanguageCode()).add(alias);
                continue;
            }
            ArrayList<MonolingualTextValue> aliasesForLanguage = new ArrayList<MonolingualTextValue>();
            aliasesForLanguage.add(alias);
            this.aliases.put(alias.getLanguageCode(), aliasesForLanguage);
        }
        if (!statementGroups.isEmpty()) {
            for (StatementGroup sg : statementGroups) {
                if (entityIdValue.equals(sg.getSubject())) continue;
                throw new IllegalArgumentException("All statement groups in a document must have the same subject: found " + sg.getSubject() + " but expected " + entityIdValue);
            }
        }
        this.statementGroups = statementGroups;
    }

    @Override
    public Map<String, MonolingualTextValue> getLabels() {
        return Collections.unmodifiableMap(this.labels);
    }

    @Override
    public Map<String, MonolingualTextValue> getDescriptions() {
        return Collections.unmodifiableMap(this.descriptions);
    }

    @Override
    public Map<String, List<MonolingualTextValue>> getAliases() {
        return Collections.unmodifiableMap(this.aliases);
    }

    @Override
    public List<StatementGroup> getStatementGroups() {
        return Collections.unmodifiableList(this.statementGroups);
    }

    @Override
    public Iterator<Statement> getAllStatements() {
        return new NestedIterator<Statement>(this.statementGroups);
    }
}

