/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;

public class StatementGroupImpl
implements StatementGroup,
Serializable {
    private static final long serialVersionUID = -7455251135036540828L;
    final List<Statement> statements;

    public StatementGroupImpl(List<Statement> statements) {
        Validate.notNull(statements, "List of statements cannot be null", new Object[0]);
        Validate.notEmpty(statements, "List of statements cannot be empty", new Object[0]);
        EntityIdValue subject = statements.get(0).getClaim().getSubject();
        PropertyIdValue property = statements.get(0).getClaim().getMainSnak().getPropertyId();
        for (Statement s2 : statements) {
            if (!subject.equals(s2.getClaim().getSubject())) {
                throw new IllegalArgumentException("All statements in a statement group must use the same subject");
            }
            if (property.equals(s2.getClaim().getMainSnak().getPropertyId())) continue;
            throw new IllegalArgumentException("All statements in a statement group must use the same main property");
        }
        this.statements = statements;
    }

    @Override
    public List<Statement> getStatements() {
        return Collections.unmodifiableList(this.statements);
    }

    @Override
    public PropertyIdValue getProperty() {
        return this.statements.get(0).getClaim().getMainSnak().getPropertyId();
    }

    @Override
    public EntityIdValue getSubject() {
        return this.statements.get(0).getClaim().getSubject();
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsStatementGroup(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }

    @Override
    public Iterator<Statement> iterator() {
        return this.statements.iterator();
    }
}

