/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.interfaces.QuantityValue;
import org.wikidata.wdtk.datamodel.interfaces.ValueVisitor;

public class QuantityValueImpl
implements QuantityValue,
Serializable {
    private static final long serialVersionUID = 3245696048836886990L;
    final BigDecimal numericValue;
    final BigDecimal lowerBound;
    final BigDecimal upperBound;

    QuantityValueImpl(BigDecimal numericValue, BigDecimal lowerBound, BigDecimal upperBound) {
        Validate.notNull(numericValue, "Numeric value cannot be null", new Object[0]);
        Validate.notNull(lowerBound, "Lower bound cannot be null", new Object[0]);
        Validate.notNull(upperBound, "Upper bound cannot be null", new Object[0]);
        if (lowerBound.compareTo(numericValue) == 1) {
            throw new IllegalArgumentException("Lower bound cannot be strictly greater than numeric value");
        }
        if (numericValue.compareTo(upperBound) == 1) {
            throw new IllegalArgumentException("Upper bound cannot be strictly smaller than numeric value");
        }
        this.numericValue = numericValue;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    @Override
    public BigDecimal getNumericValue() {
        return this.numericValue;
    }

    @Override
    public BigDecimal getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public BigDecimal getUpperBound() {
        return this.upperBound;
    }

    @Override
    public <T> T accept(ValueVisitor<T> valueVisitor) {
        return valueVisitor.visit(this);
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsQuantityValue(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }
}

