/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.implementation.NumericEntityIdValueImpl;
import org.wikidata.wdtk.datamodel.interfaces.ItemIdValue;

public class ItemIdValueImpl
extends NumericEntityIdValueImpl
implements ItemIdValue {
    private static final long serialVersionUID = -2430982177464510496L;

    public static ItemIdValueImpl create(String id, String baseIri) {
        if (id == null || id.length() <= 1 || id.charAt(0) != 'Q') {
            throw new IllegalArgumentException("Wikibase item ids must have the form \"Q<positive integer>\". Given id was \"" + id + "\"");
        }
        try {
            int numId = new Integer(id.substring(1));
            return new ItemIdValueImpl(numId, baseIri);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Wikibase item ids must have the form \"Q<positive integer>\". Given id was \"" + id + "\"");
        }
    }

    private ItemIdValueImpl(int id, String baseIri) {
        super(id, baseIri);
    }

    @Override
    public String getEntityType() {
        return "http://www.wikidata.org/ontology#Item";
    }

    public String toString() {
        return ToString.toString(this);
    }

    @Override
    public String getId() {
        return "Q" + this.id;
    }
}

