/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import java.io.Serializable;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.interfaces.GlobeCoordinatesValue;
import org.wikidata.wdtk.datamodel.interfaces.ValueVisitor;

public class GlobeCoordinatesValueImpl
implements GlobeCoordinatesValue,
Serializable {
    private static final long serialVersionUID = 5232034046447738117L;
    final double latitude;
    final double longitude;
    final double precision;
    final String globeIri;

    GlobeCoordinatesValueImpl(double latitude, double longitude, double precision, String globeIri) {
        Validate.notNull(globeIri, "globe IRI must not be null", new Object[0]);
        if (latitude > 90.0 || latitude < -90.0) {
            throw new IllegalArgumentException("Latitude must be between 90 degrees and -90 degrees.");
        }
        if (longitude > 360.0 || longitude < -360.0) {
            throw new IllegalArgumentException("Longitude must be between -360 degrees and +360 degrees.");
        }
        if (precision <= 0.0) {
            throw new IllegalArgumentException("Precision must be positive. Given value was " + precision + ".");
        }
        this.latitude = latitude;
        this.longitude = longitude;
        this.precision = precision;
        this.globeIri = globeIri;
    }

    @Override
    public double getLatitude() {
        return this.latitude;
    }

    @Override
    public double getLongitude() {
        return this.longitude;
    }

    @Override
    public double getPrecision() {
        return this.precision;
    }

    @Override
    public String getGlobe() {
        return this.globeIri;
    }

    @Override
    public <T> T accept(ValueVisitor<T> valueVisitor) {
        return valueVisitor.visit(this);
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsGlobeCoordinatesValue(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }
}

