/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.lazy.utils;

import de.fau.cs.osr.ptk.common.PrinterBase;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.NodeList;
import de.fau.cs.osr.ptk.common.ast.Text;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.sweble.wikitext.lazy.encval.IllegalCodePoint;
import org.sweble.wikitext.lazy.parser.Bold;
import org.sweble.wikitext.lazy.parser.DefinitionDefinition;
import org.sweble.wikitext.lazy.parser.DefinitionList;
import org.sweble.wikitext.lazy.parser.DefinitionTerm;
import org.sweble.wikitext.lazy.parser.Enumeration;
import org.sweble.wikitext.lazy.parser.EnumerationItem;
import org.sweble.wikitext.lazy.parser.ExternalLink;
import org.sweble.wikitext.lazy.parser.HorizontalRule;
import org.sweble.wikitext.lazy.parser.ImageHorizAlign;
import org.sweble.wikitext.lazy.parser.ImageLink;
import org.sweble.wikitext.lazy.parser.ImageVertAlign;
import org.sweble.wikitext.lazy.parser.ImageViewFormat;
import org.sweble.wikitext.lazy.parser.InternalLink;
import org.sweble.wikitext.lazy.parser.Italics;
import org.sweble.wikitext.lazy.parser.Itemization;
import org.sweble.wikitext.lazy.parser.ItemizationItem;
import org.sweble.wikitext.lazy.parser.LazyParsedPage;
import org.sweble.wikitext.lazy.parser.MagicWord;
import org.sweble.wikitext.lazy.parser.Paragraph;
import org.sweble.wikitext.lazy.parser.Section;
import org.sweble.wikitext.lazy.parser.SemiPre;
import org.sweble.wikitext.lazy.parser.SemiPreLine;
import org.sweble.wikitext.lazy.parser.Signature;
import org.sweble.wikitext.lazy.parser.Table;
import org.sweble.wikitext.lazy.parser.TableCaption;
import org.sweble.wikitext.lazy.parser.TableCell;
import org.sweble.wikitext.lazy.parser.TableHeader;
import org.sweble.wikitext.lazy.parser.TableRow;
import org.sweble.wikitext.lazy.parser.Ticks;
import org.sweble.wikitext.lazy.parser.Url;
import org.sweble.wikitext.lazy.parser.Whitespace;
import org.sweble.wikitext.lazy.parser.XmlElement;
import org.sweble.wikitext.lazy.parser.XmlElementClose;
import org.sweble.wikitext.lazy.parser.XmlElementEmpty;
import org.sweble.wikitext.lazy.parser.XmlElementOpen;
import org.sweble.wikitext.lazy.preprocessor.Ignored;
import org.sweble.wikitext.lazy.preprocessor.LazyPreprocessedPage;
import org.sweble.wikitext.lazy.preprocessor.OnlyInclude;
import org.sweble.wikitext.lazy.preprocessor.Redirect;
import org.sweble.wikitext.lazy.preprocessor.TagExtension;
import org.sweble.wikitext.lazy.preprocessor.Template;
import org.sweble.wikitext.lazy.preprocessor.TemplateArgument;
import org.sweble.wikitext.lazy.preprocessor.TemplateParameter;
import org.sweble.wikitext.lazy.preprocessor.XmlComment;
import org.sweble.wikitext.lazy.utils.TextUtils;
import org.sweble.wikitext.lazy.utils.XmlAttribute;
import org.sweble.wikitext.lazy.utils.XmlAttributeGarbage;
import org.sweble.wikitext.lazy.utils.XmlCharRef;
import org.sweble.wikitext.lazy.utils.XmlEntityRef;

public class WikitextPrinter
extends PrinterBase {
    public static String print(AstNode node) {
        StringWriter writer2 = new StringWriter();
        new WikitextPrinter(writer2).go(node);
        return writer2.toString();
    }

    public static Writer print(Writer writer2, AstNode node) {
        new WikitextPrinter(writer2).go(node);
        return writer2;
    }

    public WikitextPrinter(Writer writer2) {
        super(writer2);
    }

    public void visit(LazyPreprocessedPage page) throws IOException {
        this.iterate(page.getContent());
    }

    public void visit(LazyParsedPage page) throws IOException {
        this.iterate(page.getContent());
    }

    public void visit(NodeList list) throws IOException {
        this.iterate(list);
    }

    public void visit(Text text2) throws IOException {
        this.print(text2.getContent());
    }

    public void visit(Italics n) throws IOException {
        this.print("''");
        this.iterate(n.getContent());
        this.print("''");
    }

    public void visit(Bold n) throws IOException {
        this.print("'''");
        this.iterate(n.getContent());
        this.print("'''");
    }

    public void visit(Whitespace ws) throws IOException {
        this.printNewline(false);
        this.printNewline(false);
    }

    public void visit(Paragraph p) throws IOException {
        this.printNewline(true);
        this.iterate(p.getContent());
    }

    public void visit(Section s2) throws IOException {
        this.printNewline(true);
        this.print(WikitextPrinter.strrep('=', s2.getLevel()));
        this.print(" ");
        this.iterate(WikitextPrinter.trim(s2.getTitle()));
        this.print(" ");
        this.print(WikitextPrinter.strrep('=', s2.getLevel()));
        this.printNewline(false);
        this.incIndent("");
        this.iterate(s2.getBody());
        this.decIndent();
        this.printNewline(false);
    }

    public void visit(XmlComment e) throws IOException {
    }

    public void visit(XmlElement e) throws IOException {
        this.print("<");
        this.print(e.getName());
        this.iterate(e.getXmlAttributes());
        if (e.getEmpty().booleanValue()) {
            this.print(" />");
        } else {
            this.print(">");
            this.iterate(e.getBody());
            this.print("</");
            this.print(e.getName());
            this.print(">");
        }
    }

    public void visit(XmlAttribute a) throws IOException {
        if (a.getHasValue()) {
            this.print(" ");
            this.print(a.getName());
            this.print("=\"");
            this.iterate(a.getValue());
            this.print("\"");
        } else {
            this.print(" ");
            this.print(a.getName());
        }
    }

    public void visit(XmlAttributeGarbage g) throws IOException {
    }

    public void visit(XmlCharRef ref) throws IOException {
        this.print("&#");
        this.print(ref.getCodePoint());
        this.print(";");
    }

    public void visit(XmlEntityRef ref) throws IOException {
        this.print("&");
        this.print(ref.getName());
        this.print(";");
    }

    public void visit(SemiPre sp2) throws IOException {
        this.printNewline(true);
        this.iterate(sp2.getContent());
    }

    public void visit(SemiPreLine l) throws IOException {
        this.printNewline(false);
        this.print(" ");
        this.iterate(l.getContent());
        this.printNewline(false);
    }

    public void visit(DefinitionList n) throws IOException {
        this.printNewline(true);
        this.iterate(n.getContent());
    }

    public void visit(DefinitionTerm n) throws IOException {
        this.printNewline(false);
        this.print("; ");
        this.iterate(WikitextPrinter.trim(n.getContent()));
        this.printNewline(false);
    }

    public void visit(DefinitionDefinition n) throws IOException {
        this.printNewline(false);
        this.print(": ");
        this.iterate(WikitextPrinter.trim(n.getContent()));
        this.printNewline(false);
    }

    public void visit(Enumeration n) throws IOException {
        this.printNewline(true);
        this.iterate(n.getContent());
    }

    public void visit(EnumerationItem n) throws IOException {
        this.printNewline(false);
        this.print("# ");
        this.iterate(WikitextPrinter.trim(n.getContent()));
        this.printNewline(false);
    }

    public void visit(Itemization n) throws IOException {
        this.printNewline(true);
        this.iterate(n.getContent());
    }

    public void visit(ItemizationItem n) throws IOException {
        this.printNewline(false);
        this.print("* ");
        this.iterate(WikitextPrinter.trim(n.getContent()));
        this.printNewline(false);
    }

    public void visit(ExternalLink link) throws IOException {
        this.print("[");
        this.print(link.getTarget().getProtocol());
        this.print(":");
        this.print(link.getTarget().getPath());
        if (!link.getTitle().isEmpty()) {
            this.print(" ");
            this.iterate(WikitextPrinter.trim(link.getTitle()));
        }
        this.print("]");
    }

    public void visit(Url url) throws IOException {
        this.print(url.getProtocol());
        this.print(":");
        this.print(url.getPath());
    }

    public void visit(InternalLink n) throws IOException {
        this.print(n.getPrefix());
        this.print("[[");
        this.print(n.getTarget());
        if (!n.getTitle().getContent().isEmpty()) {
            this.print("|");
            this.iterate(n.getTitle().getContent());
        }
        this.print("]]");
        this.print(n.getPostfix());
    }

    public void visit(ImageLink n) throws IOException {
        this.print("[[");
        this.print(n.getTarget());
        this.print(WikitextPrinter.imageLinkOptions(n));
        if (!n.getAlt().isEmpty()) {
            this.print("|alt=");
            this.iterate(n.getAlt());
        }
        if (!n.getTitle().getContent().isEmpty()) {
            this.print("|");
            this.iterate(n.getTitle().getContent());
        }
        this.print("]]");
    }

    public void visit(Table table) throws IOException {
        this.printNewline(true);
        this.print("{");
        this.print("|");
        this.iterate(table.getXmlAttributes());
        this.printNewline(false);
        this.incIndent("");
        this.iterate(table.getBody());
        this.decIndent();
        this.printNewline(false);
        this.printNewline(true);
        this.print("|}");
    }

    public void visit(TableCaption caption) throws IOException {
        this.printNewline(false);
        this.print("|+");
        if (!caption.getXmlAttributes().isEmpty()) {
            this.iterate(caption.getXmlAttributes());
            this.print(" |");
        }
        this.print(" ");
        this.iterate(WikitextPrinter.trim(caption.getBody()));
        this.printNewline(false);
    }

    public void visit(TableRow row) throws IOException {
        this.printNewline(false);
        this.print("|-");
        if (!row.getXmlAttributes().isEmpty()) {
            this.iterate(row.getXmlAttributes());
        }
        this.printNewline(false);
        this.incIndent("");
        this.iterate(row.getBody());
        this.decIndent();
        this.printNewline(false);
        this.printNewline(false);
    }

    public void visit(TableHeader header) throws IOException {
        this.printNewline(false);
        this.print("!");
        if (!header.getXmlAttributes().isEmpty()) {
            this.iterate(header.getXmlAttributes());
            this.print(" |");
        }
        this.print(" ");
        this.iterate(WikitextPrinter.trim(header.getBody()));
        this.printNewline(false);
    }

    public void visit(TableCell cell) throws IOException {
        this.printNewline(false);
        this.print("|");
        if (!cell.getXmlAttributes().isEmpty()) {
            this.iterate(cell.getXmlAttributes());
            this.print(" |");
        }
        this.print(" ");
        this.iterate(WikitextPrinter.trim(cell.getBody()));
        this.printNewline(false);
    }

    public void visit(HorizontalRule rule) throws IOException {
        this.printNewline(true);
        this.printNewline(true);
        this.print("----");
    }

    public void visit(Signature sig) throws IOException {
        this.print(WikitextPrinter.strrep('~', sig.getTildeCount()));
    }

    public void visit(TagExtension n) throws IOException {
        if (n.getBody().isEmpty()) {
            this.print("<");
            this.print(n.getName());
            this.iterate(n.getXmlAttributes());
            this.print(" />");
        } else {
            this.print("<");
            this.print(n.getName());
            this.iterate(n.getXmlAttributes());
            this.print(">");
            this.print(n.getBody());
            this.print("</");
            this.print(n.getName());
            this.print(">");
        }
    }

    public void visit(XmlElementEmpty e) throws IOException {
        this.print("<");
        this.print(e.getName());
        this.iterate(e.getXmlAttributes());
        this.print(" />");
    }

    public void visit(XmlElementOpen e) throws IOException {
        this.print("<");
        this.print(e.getName());
        this.iterate(e.getXmlAttributes());
        this.print(">");
    }

    public void visit(XmlElementClose e) throws IOException {
        this.print("</");
        this.print(e.getName());
        this.print(">");
    }

    public void visit(Template tmpl) throws IOException {
        this.print("{");
        this.print("{");
        this.iterate(tmpl.getName());
        this.iterate(tmpl.getArgs());
        this.print("}}");
    }

    public void visit(TemplateParameter param2) throws IOException {
        this.print("{");
        this.print("{");
        this.print("{");
        this.iterate(param2.getName());
        this.dispatch(param2.getDefaultValue());
        this.iterate(param2.getGarbage());
        this.print("}}}");
    }

    public void visit(TemplateArgument arg) throws IOException {
        this.print("|");
        if (!arg.getHasName()) {
            this.iterate(arg.getValue());
        } else {
            this.iterate(arg.getName());
            this.print("=");
            this.iterate(arg.getValue());
        }
    }

    public void visit(Ticks ticks) throws IOException {
        this.print(WikitextPrinter.strrep('\'', ticks.getTickCount()));
    }

    public void visit(MagicWord word) throws IOException {
        this.print("__");
        this.print(word.getWord());
        this.print("__");
    }

    public void visit(Redirect r) throws IOException {
        this.print("#REDIRECT[[");
        this.print(r.getTarget());
        this.print("]]");
    }

    public void visit(IllegalCodePoint icp) throws IOException {
        this.print(icp.getCodePoint());
    }

    public void visit(Ignored i) throws IOException {
    }

    public void visit(OnlyInclude oi) throws IOException {
        this.iterate(oi.getContent());
    }

    private static NodeList trim(NodeList l) {
        return TextUtils.trim(l);
    }

    private static String imageLinkOptions(ImageLink n) {
        StringBuilder s2 = new StringBuilder();
        if (n.getWidth() >= 0 || n.getHeight() >= 0) {
            s2.append('|');
            if (n.getWidth() >= 0) {
                s2.append(n.getWidth());
            }
            s2.append('x');
            if (n.getHeight() >= 0) {
                s2.append(n.getHeight());
            }
            s2.append("px");
        }
        if (n.getUpright()) {
            s2.append("|upright");
        }
        if (n.getHAlign() != ImageHorizAlign.NONE) {
            s2.append('|');
            s2.append(n.getHAlign().asKeyword());
        }
        if (n.getVAlign() != ImageVertAlign.MIDDLE) {
            s2.append('|');
            s2.append(n.getVAlign().asKeyword());
        }
        if (n.getFormat() != ImageViewFormat.UNRESTRAINED) {
            s2.append('|');
            s2.append(n.getFormat().asKeyword());
        }
        if (n.getBorder()) {
            s2.append("|border");
        }
        if (n.getLinkPage() != null) {
            s2.append("|link=");
            s2.append(n.getLinkPage());
        }
        if (n.getLinkUrl() != null) {
            s2.append("|link=");
            s2.append(n.getLinkUrl().getProtocol());
            s2.append(':');
            s2.append(n.getLinkUrl().getPath());
        }
        return s2.toString();
    }
}

