/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.lazy.utils;

import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.NodeList;
import de.fau.cs.osr.ptk.common.ast.Text;
import de.fau.cs.osr.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import org.sweble.wikitext.lazy.parser.RtData;

public final class TextUtils {
    public static NodeList trim(NodeList nodes) {
        ArrayList<AstNode> result2 = new ArrayList<AstNode>(nodes);
        TextUtils.trimLeft(result2);
        TextUtils.trimRight(result2);
        return new NodeList(result2);
    }

    public static NodeList trimLeft(NodeList nodes) {
        ArrayList<AstNode> result2 = new ArrayList<AstNode>(nodes);
        TextUtils.trimLeft(result2);
        return new NodeList(result2);
    }

    public static NodeList trimRight(NodeList nodes) {
        ArrayList<AstNode> result2 = new ArrayList<AstNode>(nodes);
        TextUtils.trimRight(result2);
        return new NodeList(result2);
    }

    public static NodeList trimAndPad(NodeList nodes, int spaces2) {
        ArrayList<AstNode> result2 = new ArrayList<AstNode>(nodes);
        TextUtils.trimLeft(result2);
        TextUtils.trimRight(result2);
        if (spaces2 <= 0) {
            return new NodeList(result2);
        }
        return TextUtils.pad(result2, spaces2);
    }

    public static void trimLeft(ArrayList<AstNode> result2) {
        int i = 0;
        block4: while (i < result2.size()) {
            switch (result2.get(i).getNodeType()) {
                case 4097: {
                    Text stringNode = (Text)result2.get(i);
                    String trimmed = TextUtils.trimLeft(stringNode.getContent());
                    if (trimmed == stringNode.getContent()) break block4;
                    if (trimmed.isEmpty()) {
                        result2.remove(i);
                        continue block4;
                    }
                    result2.set(i, new Text(trimmed));
                    break block4;
                }
                case 458754: {
                    ++i;
                    continue block4;
                }
            }
        }
    }

    public static void trimRight(ArrayList<AstNode> result2) {
        int i = result2.size() - 1;
        block4: while (i >= 0) {
            switch (result2.get(i).getNodeType()) {
                case 4097: {
                    Text stringNode = (Text)result2.get(i);
                    String trimmed = TextUtils.trimRight(stringNode.getContent());
                    if (trimmed == stringNode.getContent()) break block4;
                    if (trimmed.isEmpty()) {
                        result2.remove(i--);
                        continue block4;
                    }
                    result2.set(i, new Text(trimmed));
                    break block4;
                }
                case 458754: {
                    --i;
                    continue block4;
                }
            }
        }
    }

    public static NodeList pad(ArrayList<AstNode> result2, int spaces2) {
        if (spaces2 <= 0) {
            return new NodeList(result2);
        }
        if (result2.isEmpty()) {
            result2.add(new Text(StringUtils.strrep(' ', spaces2 * 2)));
        } else {
            String spacesString = StringUtils.strrep(' ', spaces2);
            Text before = null;
            if (result2.get(0).isNodeType(4097)) {
                before = (Text)result2.remove(0);
            }
            String spaced = "";
            if (before != null) {
                spaced = before.getContent();
            }
            spaced = spacesString + spaced;
            result2.add(0, new Text(spaced));
            Text after = null;
            int i = result2.size() - 1;
            if (result2.get(i).isNodeType(4097)) {
                after = (Text)result2.remove(i);
            }
            spaced = "";
            if (after != null) {
                spaced = after.getContent();
            }
            spaced = spaced + spacesString;
            result2.add(new Text(spaced));
        }
        return new NodeList(result2);
    }

    public static String trim(String text2) {
        int from2;
        int length = text2.length();
        for (from2 = 0; from2 < length && Character.isWhitespace(text2.charAt(from2)); ++from2) {
        }
        while (from2 < length && Character.isWhitespace(text2.charAt(length - 1))) {
            --length;
        }
        if (from2 > 0 || length < text2.length()) {
            return text2.substring(from2, length);
        }
        return text2;
    }

    public static String trimLeft(String text2) {
        int from2;
        int length = text2.length();
        for (from2 = 0; from2 < length && Character.isWhitespace(text2.charAt(from2)); ++from2) {
        }
        if (from2 > 0) {
            return text2.substring(from2, length);
        }
        return text2;
    }

    public static String trimRight(String text2) {
        int length;
        for (length = text2.length(); 0 < length && Character.isWhitespace(text2.charAt(length - 1)); --length) {
        }
        if (length < text2.length()) {
            return text2.substring(0, length);
        }
        return text2;
    }

    public static RtData addRtData(AstNode yyValue, Object[] ... rts) {
        if (rts.length != yyValue.size() + 1) {
            rts = (Object[][])Arrays.copyOf(rts, yyValue.size() + 1);
        }
        RtData data = new RtData(rts);
        yyValue.setAttribute("RTD", data);
        return data;
    }

    public static Object[] joinRt(Object ... objects) {
        ArrayList<Object> result2 = new ArrayList<Object>();
        block4: for (Object o : objects) {
            if (o instanceof AstNode) {
                AstNode a = (AstNode)o;
                switch (a.getNodeType()) {
                    case 2: {
                        for (AstNode c : (NodeList)a) {
                            if (c.getNodeType() == 4097) {
                                TextUtils.rtAddString(result2, ((Text)c).getContent());
                                continue;
                            }
                            result2.add(c);
                        }
                        continue block4;
                    }
                    case 4097: {
                        TextUtils.rtAddString(result2, ((Text)a).getContent());
                        break;
                    }
                    default: {
                        result2.add(a);
                    }
                }
                continue;
            }
            if (o == null) continue;
            if (o instanceof Character) {
                TextUtils.rtAddString(result2, String.valueOf((Character)o));
                continue;
            }
            TextUtils.rtAddString(result2, (String)o);
        }
        return result2.toArray();
    }

    public static void rtAddString(ArrayList<Object> result2, String so) {
        int last2 = result2.size() - 1;
        if (last2 >= 0 && result2.get(last2) instanceof String) {
            result2.set(last2, result2.get(last2) + so);
        } else {
            result2.add(so);
        }
    }

    public static void prependRtData(AstNode n, String data) {
        RtData rtd = (RtData)n.getAttribute("RTD");
        if (rtd == null || rtd.getRts().length == 0) {
            TextUtils.addRtData(n, new Object[][]{TextUtils.joinRt(data)});
        } else {
            Object[] rtd0 = rtd.getRts()[0];
            if (rtd0 == null || rtd0.length == 0) {
                rtd0 = new Object[]{data};
            } else if (rtd0[0] instanceof String) {
                rtd0 = (Object[])rtd0.clone();
                rtd0[0] = data + rtd0[0];
            } else {
                Object[] rtd0_ = new Object[rtd0.length + 1];
                rtd0_[0] = data;
                System.arraycopy(rtd0, 0, rtd0_, 1, rtd0.length);
            }
            Object[][] rts = (Object[][])rtd.getRts().clone();
            rts[0] = rtd0;
            n.setAttribute("RTD", new RtData(rts));
        }
    }
}

