/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.lazy.utils;

import de.fau.cs.osr.ptk.common.AstVisitor;
import de.fau.cs.osr.ptk.common.VisitingException;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.NodeList;
import de.fau.cs.osr.ptk.common.ast.Text;
import org.sweble.wikitext.lazy.ParserConfigInterface;
import org.sweble.wikitext.lazy.preprocessor.Ignored;
import org.sweble.wikitext.lazy.preprocessor.XmlComment;
import org.sweble.wikitext.lazy.utils.StringConversionException;
import org.sweble.wikitext.lazy.utils.XmlCharRef;
import org.sweble.wikitext.lazy.utils.XmlEntityRef;

public class StringConverter {
    public static final int RESOLVE_CHAR_REF = 1;
    public static final int RESOLVE_ENTITY_REF = 2;
    public static final int FAIL_ON_UNRESOLVED_XML_ENTITY = 4;
    public static final int FAIL_ON_XML_COMMENTS = 8;
    public static final int FAIL_ON_IGNORED = 16;
    public static final int DEFAULT_OPTIONS = 0;

    public static String convert(AstNode astNode) throws StringConversionException {
        return StringConverter.convert(astNode, null, 0);
    }

    public static String convert(AstNode astNode, ParserConfigInterface resolver, int options) throws StringConversionException {
        ConverterVisitor converter = new ConverterVisitor(options, resolver);
        try {
            return (String)converter.go(astNode);
        }
        catch (VisitingException e) {
            if (e.getCause() instanceof StringConversionException) {
                throw (StringConversionException)e.getCause();
            }
            throw e;
        }
    }

    protected static final class ConverterVisitor
    extends AstVisitor {
        private final StringBuilder result = new StringBuilder();
        private final ParserConfigInterface entityResolver;
        private final int options;

        public ConverterVisitor(int options, ParserConfigInterface resolver) {
            this.entityResolver = resolver;
            this.options = options;
            if (resolver != null && !this.opt(2)) {
                throw new IllegalArgumentException("If a resolver instance is given the option RESOLVE_ENTITY_REF is required");
            }
            if (resolver == null && this.opt(2)) {
                throw new IllegalArgumentException("If the option RESOLVE_ENTITY_REF is given a resolver instance is required");
            }
        }

        @Override
        protected Object after(AstNode node, Object result2) {
            return this.result.toString();
        }

        @Override
        public Object visitNotFound(AstNode node) {
            throw new VisitingException(new StringConversionException(node));
        }

        public void visit(NodeList n) {
            this.iterate(n);
        }

        public void visit(XmlCharRef n) throws StringConversionException {
            if (this.opt(1)) {
                this.result.append(Character.toChars(n.getCodePoint()));
            } else {
                if (this.opt(4)) {
                    throw new StringConversionException(n);
                }
                this.result.append("&#");
                this.result.append(n.getCodePoint());
                this.result.append(';');
            }
        }

        public void visit(XmlEntityRef n) throws StringConversionException {
            String replacement = null;
            if (this.opt(2)) {
                replacement = this.entityResolver.resolveXmlEntity(n.getName());
            }
            if (replacement == null) {
                if (this.opt(4)) {
                    throw new StringConversionException(n);
                }
                this.result.append('&');
                this.result.append(n.getName());
                this.result.append(';');
            } else {
                this.result.append(replacement);
            }
        }

        public void visit(Text n) {
            this.result.append(n.getContent());
        }

        public void visit(XmlComment n) throws StringConversionException {
            if (this.opt(8)) {
                throw new StringConversionException(n);
            }
        }

        public void visit(Ignored n) throws StringConversionException {
            if (this.opt(16)) {
                throw new StringConversionException(n);
            }
        }

        private boolean opt(int x) {
            return (this.options & x) == x;
        }
    }
}

