/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.lazy.utils;

import de.fau.cs.osr.ptk.common.AstVisitor;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class NodeStats {
    public static void process(AstNode astNode) {
        new NodeStatsVisitor().go(astNode);
    }

    protected static final class NodeStatsVisitor
    extends AstVisitor {
        private final Map<String, Integer> nodeCounts = new HashMap<String, Integer>();
        private int varCount = 0;
        private int varEmptyCount = 0;
        private int varChildCount = 0;
        private int varMaxChildCount = -1;
        private int fixCount = 0;
        private int fixChildCount = 0;
        private int leafCount = 0;

        protected NodeStatsVisitor() {
        }

        @Override
        protected Object after(AstNode node, Object result2) {
            System.out.println("Analysis:");
            ArrayList<String> nodeNames = new ArrayList<String>(this.nodeCounts.keySet());
            Collections.sort(nodeNames);
            int sum2 = 0;
            for (String name2 : nodeNames) {
                int count2 = this.nodeCounts.get(name2);
                sum2 += count2;
                String space = StringUtils.strrep('.', 80 - name2.length());
                System.out.format("  %s %s %5d\n", name2, space, count2);
            }
            System.out.println("  " + StringUtils.strrep('=', 87));
            System.out.format("  %s%5d\n", StringUtils.strrep(' ', 82), sum2);
            System.out.println();
            System.out.println("  Nodes with variable number of children: ");
            System.out.format("     Count:   %5d\n", this.varCount);
            System.out.format("     Leaf:    %5d\n", this.varEmptyCount);
            System.out.format("     Biggest: %5d\n", this.varMaxChildCount);
            System.out.format("     Average:    %5.2f\n", Float.valueOf((float)this.varChildCount / (float)(this.varCount - this.varEmptyCount)));
            System.out.println();
            System.out.println("  Nodes with fixed number of children: ");
            System.out.format("     Inner:   %5d\n", this.fixCount);
            System.out.format("     Leafs:   %5d\n", this.leafCount);
            System.out.format("     Average:    %5.2f\n", Float.valueOf((float)this.fixChildCount / (float)this.fixCount));
            return super.after(node, result2);
        }

        public void visit(AstNode n) {
            if (n != null) {
                this.countNode(n);
                int size2 = n.size();
                if (n.isList()) {
                    ++this.varCount;
                    this.varChildCount += size2;
                    if (n.isEmpty()) {
                        ++this.varEmptyCount;
                    }
                    if (size2 > this.varMaxChildCount) {
                        this.varMaxChildCount = size2;
                    }
                } else if (!n.isEmpty()) {
                    ++this.fixCount;
                    this.fixChildCount += size2;
                } else {
                    ++this.leafCount;
                }
                this.iterate(n);
            }
        }

        private void countNode(AstNode n) {
            Class<?> clazz = n.getClass();
            String name2 = clazz.getName();
            Integer i = this.nodeCounts.get(name2);
            if (i == null) {
                i = 0;
            }
            this.nodeCounts.put(name2, i + 1);
        }
    }
}

