/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.lazy.postprocessor;

import de.fau.cs.osr.ptk.common.AstVisitor;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.ContentNode;
import de.fau.cs.osr.ptk.common.ast.LeafNode;
import de.fau.cs.osr.ptk.common.ast.NodeList;
import de.fau.cs.osr.ptk.common.ast.StringContentNode;
import de.fau.cs.osr.ptk.common.ast.Text;
import de.fau.cs.osr.utils.FmtInternalLogicError;
import de.fau.cs.osr.utils.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.sweble.wikitext.lazy.parser.DefinitionDefinition;
import org.sweble.wikitext.lazy.parser.DefinitionTerm;
import org.sweble.wikitext.lazy.parser.EnumerationItem;
import org.sweble.wikitext.lazy.parser.ItemizationItem;
import org.sweble.wikitext.lazy.parser.SemiPreLine;
import org.sweble.wikitext.lazy.parser.Ticks;
import org.sweble.wikitext.lazy.parser.Whitespace;
import org.sweble.wikitext.lazy.postprocessor.IntermediateTags;

public class TicksAnalyzer {
    public static AstNode process(AstNode a) {
        LinkedList<Line> lines2 = new LinkedList<Line>();
        new LineAnalyzer(lines2).go(a);
        if (lines2.isEmpty()) {
            return a;
        }
        TicksAnalyzer.analyzeOddTicksCombos(lines2);
        return (AstNode)new TicksConverter(lines2).go(a);
    }

    private static void analyzeOddTicksCombos(LinkedList<Line> lines2) {
        for (Line line : lines2) {
            if (line.numBold % 2 != 1 || line.numItalics % 2 != 1) continue;
            int firstSpace = -1;
            int firstSlWord = -1;
            int firstMlWord = -1;
            for (int i = 0; i < line.ticks.size(); ++i) {
                LineEntry entry = line.ticks.get(i);
                AstNode p = entry.previous;
                if (p == null || entry.tickCount != 3) continue;
                if (p instanceof ContentNode) {
                    ContentNode c = (ContentNode)p;
                    p = null;
                    if (!c.isEmpty()) {
                        p = c.get(c.size() - 1);
                    }
                }
                int tMinus1 = 0;
                int tMinus2 = 0;
                if (p instanceof StringContentNode) {
                    String t = ((StringContentNode)p).getContent();
                    if (t.length() >= 1) {
                        tMinus1 = t.charAt(t.length() - 1);
                    }
                    if (t.length() >= 2) {
                        tMinus2 = t.charAt(t.length() - 2);
                    }
                }
                if (tMinus1 == 32) {
                    if (firstSpace != -1) continue;
                    firstSpace = i;
                    continue;
                }
                if (tMinus2 == 32) {
                    if (firstSlWord != -1) continue;
                    firstSlWord = i;
                    continue;
                }
                if (firstMlWord != -1) continue;
                firstMlWord = i;
            }
            if (firstSlWord != -1) {
                TicksAnalyzer.apostrophize(line.ticks.get(firstSlWord));
                continue;
            }
            if (firstMlWord != -1) {
                TicksAnalyzer.apostrophize(line.ticks.get(firstMlWord));
                continue;
            }
            if (firstSpace == -1) continue;
            TicksAnalyzer.apostrophize(line.ticks.get(firstSpace));
        }
    }

    private static void apostrophize(LineEntry entry) {
        --entry.tickCount;
        if (entry.prefix != null) {
            String t = entry.prefix.getContent() + "'";
            entry.prefix.setContent(t);
        } else {
            entry.prefix = new Text("'");
        }
    }

    protected static final class TicksConverter
    extends AstVisitor {
        private Iterator<Line> lineIter;
        private Iterator<LineEntry> entryIter;
        private State state = State.None;

        public TicksConverter(LinkedList<Line> lines2) {
            this.lineIter = lines2.iterator();
            if (this.lineIter.hasNext()) {
                this.entryIter = this.lineIter.next().ticks.iterator();
            }
        }

        public AstNode visit(AstNode n) {
            this.mapInPlace(n);
            return n;
        }

        public AstNode visit(LeafNode n) {
            return n;
        }

        public AstNode visit(Ticks n) {
            LineEntry entry = this.nextEntry();
            NodeList result2 = new NodeList(entry.prefix);
            this.toTag(entry, result2);
            return result2;
        }

        public AstNode visit(Whitespace ws) {
            if (!ws.getHasNewline()) {
                return ws;
            }
            NodeList result2 = this.closeRemainingTags();
            if (result2 == null) {
                return ws;
            }
            this.state = State.None;
            result2.add(ws);
            return result2;
        }

        public AstNode visit(ItemizationItem n) {
            return this.implicitLineScope(n);
        }

        public AstNode visit(EnumerationItem n) {
            return this.implicitLineScope(n);
        }

        public AstNode visit(DefinitionTerm n) {
            return this.implicitLineScope(n);
        }

        public AstNode visit(DefinitionDefinition n) {
            return this.implicitLineScope(n);
        }

        public AstNode visit(SemiPreLine n) {
            return this.implicitLineScope(n);
        }

        private AstNode implicitLineScope(ContentNode n) {
            NodeList content = n.getContent();
            this.mapInPlace(content);
            this.finishLine(content);
            return n;
        }

        private void finishLine(NodeList body) {
            NodeList result2 = this.closeRemainingTags();
            if (result2 == null) {
                return;
            }
            this.state = State.None;
            body.add(result2);
        }

        private LineEntry nextEntry() {
            if (!this.entryIter.hasNext()) {
                Line line = this.lineIter.next();
                this.entryIter = line.ticks.iterator();
            }
            return this.entryIter.next();
        }

        private void toTag(LineEntry entry, NodeList result2) {
            block0 : switch (entry.tickCount) {
                case 2: {
                    switch (this.state) {
                        case Italics: {
                            result2.add(IntermediateTags.ITALICS.createClose(false));
                            this.state = State.None;
                            break;
                        }
                        case BoldItalics: {
                            result2.add(IntermediateTags.ITALICS.createClose(false));
                            this.state = State.Bold;
                            break;
                        }
                        case ItalicsBold: {
                            result2.add(IntermediateTags.BOLD.createClose(true));
                            result2.add(IntermediateTags.ITALICS.createClose(false));
                            result2.add(IntermediateTags.BOLD.createOpen(true));
                            this.state = State.Bold;
                            break;
                        }
                        case Bold: {
                            result2.add(IntermediateTags.ITALICS.createOpen(false));
                            this.state = State.BoldItalics;
                            break;
                        }
                        case None: {
                            result2.add(IntermediateTags.ITALICS.createOpen(false));
                            this.state = State.Italics;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (this.state) {
                        case Bold: {
                            result2.add(IntermediateTags.BOLD.createClose(false));
                            this.state = State.None;
                            break;
                        }
                        case BoldItalics: {
                            result2.add(IntermediateTags.ITALICS.createClose(true));
                            result2.add(IntermediateTags.BOLD.createClose(false));
                            result2.add(IntermediateTags.ITALICS.createOpen(true));
                            this.state = State.Italics;
                            break;
                        }
                        case ItalicsBold: {
                            result2.add(IntermediateTags.BOLD.createClose(false));
                            this.state = State.Italics;
                            break;
                        }
                        case Italics: {
                            result2.add(IntermediateTags.BOLD.createOpen(false));
                            this.state = State.ItalicsBold;
                            break;
                        }
                        case None: {
                            result2.add(IntermediateTags.BOLD.createOpen(false));
                            this.state = State.Bold;
                        }
                    }
                    break;
                }
                case 5: {
                    switch (this.state) {
                        case Italics: {
                            result2.add(IntermediateTags.ITALICS.createClose(false));
                            result2.add(IntermediateTags.BOLD.createOpen(false));
                            this.state = State.Bold;
                            break block0;
                        }
                        case Bold: {
                            result2.add(IntermediateTags.BOLD.createClose(false));
                            result2.add(IntermediateTags.ITALICS.createOpen(false));
                            this.state = State.Italics;
                            break block0;
                        }
                        case BoldItalics: {
                            result2.add(IntermediateTags.ITALICS.createClose(false));
                            result2.add(IntermediateTags.BOLD.createClose(false));
                            this.state = State.None;
                            break block0;
                        }
                        case ItalicsBold: {
                            result2.add(IntermediateTags.BOLD.createClose(false));
                            result2.add(IntermediateTags.ITALICS.createClose(false));
                            this.state = State.None;
                            break block0;
                        }
                        case None: {
                            result2.add(IntermediateTags.ITALICS.createOpen(false));
                            result2.add(IntermediateTags.BOLD.createOpen(false));
                            this.state = State.ItalicsBold;
                        }
                    }
                }
            }
        }

        private NodeList closeRemainingTags() {
            NodeList result2 = null;
            switch (this.state) {
                case Italics: {
                    result2 = new NodeList();
                    result2.add(IntermediateTags.ITALICS.createClose(true));
                    break;
                }
                case Bold: {
                    result2 = new NodeList();
                    result2.add(IntermediateTags.BOLD.createClose(true));
                    break;
                }
                case BoldItalics: {
                    result2 = new NodeList();
                    result2.add(IntermediateTags.ITALICS.createClose(true));
                    result2.add(IntermediateTags.BOLD.createClose(true));
                    break;
                }
                case ItalicsBold: {
                    result2 = new NodeList();
                    result2.add(IntermediateTags.BOLD.createClose(true));
                    result2.add(IntermediateTags.ITALICS.createClose(true));
                }
            }
            return result2;
        }

        private static enum State {
            None,
            Italics,
            Bold,
            ItalicsBold,
            BoldItalics;

        }
    }

    protected static final class LineAnalyzer
    extends AstVisitor {
        private final LinkedList<Line> lines;
        private ArrayList<LineEntry> ticks;
        private int numItalics = 0;
        private int numBold = 0;
        private AstNode previous = null;

        public LineAnalyzer(LinkedList<Line> lines2) {
            this.lines = lines2;
        }

        @Override
        protected Object after(AstNode node, Object result2) {
            this.finishLine();
            return node;
        }

        public void visit(AstNode n) {
            this.iterate(n);
        }

        public void visit(NodeList list) {
            this.previous = null;
            for (AstNode n : list) {
                this.dispatch(n);
                this.previous = n;
            }
            this.previous = null;
        }

        public void visit(Whitespace ws) {
            if (ws.getHasNewline()) {
                this.finishLine();
            }
        }

        public void visit(ItemizationItem n) {
            this.visit(n.getContent());
            this.finishLine();
        }

        public void visit(EnumerationItem n) {
            this.visit(n.getContent());
            this.finishLine();
        }

        public void visit(DefinitionTerm n) {
            this.visit(n.getContent());
            this.finishLine();
        }

        public void visit(DefinitionDefinition n) {
            this.visit(n.getContent());
            this.finishLine();
        }

        public void visit(SemiPreLine n) {
            this.visit(n.getContent());
            this.finishLine();
        }

        public void visit(LeafNode n) {
        }

        public void visit(Ticks n) {
            if (this.ticks == null) {
                this.ticks = new ArrayList();
            }
            int tickCount = n.getTickCount();
            switch (tickCount) {
                case 2: {
                    this.ticks.add(new LineEntry(null, null, 2));
                    ++this.numItalics;
                    break;
                }
                case 3: {
                    this.ticks.add(new LineEntry(this.previous, null, 3));
                    ++this.numBold;
                    break;
                }
                case 4: {
                    this.ticks.add(new LineEntry(this.previous, new Text("'"), 3));
                    ++this.numBold;
                    break;
                }
                case 5: {
                    this.ticks.add(new LineEntry(null, null, 5));
                    ++this.numBold;
                    ++this.numItalics;
                    break;
                }
                default: {
                    if (n.getTickCount() <= 5) {
                        throw new FmtInternalLogicError();
                    }
                    String excessTicks = StringUtils.strrep('\'', tickCount - 5);
                    this.ticks.add(new LineEntry(null, new Text(excessTicks), 5));
                    ++this.numBold;
                    ++this.numItalics;
                }
            }
        }

        private void finishLine() {
            if (this.ticks == null) {
                return;
            }
            this.lines.add(new Line(this.numItalics, this.numBold, this.ticks));
            this.numItalics = 0;
            this.numBold = 0;
            this.ticks = null;
        }
    }

    protected static final class Line {
        public final int numItalics;
        public final int numBold;
        public final ArrayList<LineEntry> ticks;

        public Line(int numItalics, int numBold, ArrayList<LineEntry> ticks) {
            this.numItalics = numItalics;
            this.numBold = numBold;
            this.ticks = ticks;
        }

        public String toString() {
            return String.format("Line(#i = %d, #b = %d): %s", this.numItalics, this.numBold, this.ticks != null ? this.ticks.toString() : "-");
        }
    }

    protected static final class LineEntry {
        public final AstNode previous;
        public Text prefix;
        public int tickCount;

        public LineEntry(AstNode previous, Text prefix, int tickCount) {
            this.previous = previous;
            this.prefix = prefix;
            this.tickCount = tickCount;
        }

        public String toString() {
            String pv = "null";
            if (this.previous != null) {
                pv = this.previous.getNodeName();
                if (this.previous.isNodeType(4097) && (pv = ((Text)this.previous).getContent()).length() > 16) {
                    pv = pv.substring(pv.length() - 12);
                    pv = "... " + pv;
                }
                pv = '\"' + pv + '\"';
            }
            String pf = "-";
            if (this.prefix != null) {
                pf = '\"' + this.prefix.getContent() + '\"';
            }
            return String.format("LineEntry(%s, %s, %d)", pv, pf, this.tickCount);
        }
    }
}

