/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.lazy.postprocessor;

import de.fau.cs.osr.ptk.common.AstVisitor;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.ContentNode;
import de.fau.cs.osr.ptk.common.ast.NodeList;
import de.fau.cs.osr.utils.FmtInternalLogicError;
import java.util.LinkedList;
import org.sweble.wikitext.lazy.ParserConfigInterface;
import org.sweble.wikitext.lazy.parser.DefinitionDefinition;
import org.sweble.wikitext.lazy.parser.DefinitionList;
import org.sweble.wikitext.lazy.parser.DefinitionTerm;
import org.sweble.wikitext.lazy.parser.Enumeration;
import org.sweble.wikitext.lazy.parser.EnumerationItem;
import org.sweble.wikitext.lazy.parser.ExternalLink;
import org.sweble.wikitext.lazy.parser.ImageLink;
import org.sweble.wikitext.lazy.parser.InternalLink;
import org.sweble.wikitext.lazy.parser.Itemization;
import org.sweble.wikitext.lazy.parser.ItemizationItem;
import org.sweble.wikitext.lazy.parser.LazyParsedPage;
import org.sweble.wikitext.lazy.parser.NamedXmlElement;
import org.sweble.wikitext.lazy.parser.RtData;
import org.sweble.wikitext.lazy.parser.Section;
import org.sweble.wikitext.lazy.parser.SemiPre;
import org.sweble.wikitext.lazy.parser.SemiPreLine;
import org.sweble.wikitext.lazy.parser.Table;
import org.sweble.wikitext.lazy.parser.TableCaption;
import org.sweble.wikitext.lazy.parser.TableCell;
import org.sweble.wikitext.lazy.parser.TableHeader;
import org.sweble.wikitext.lazy.parser.TableRow;
import org.sweble.wikitext.lazy.parser.XmlElement;
import org.sweble.wikitext.lazy.parser.XmlElementClose;
import org.sweble.wikitext.lazy.parser.XmlElementEmpty;
import org.sweble.wikitext.lazy.parser.XmlElementOpen;
import org.sweble.wikitext.lazy.postprocessor.ElementScopeStack;
import org.sweble.wikitext.lazy.postprocessor.ImTagClose;
import org.sweble.wikitext.lazy.postprocessor.ImTagOpen;
import org.sweble.wikitext.lazy.postprocessor.IntermediateTag;
import org.sweble.wikitext.lazy.postprocessor.ScopeType;
import org.sweble.wikitext.lazy.utils.TextUtils;

public class ScopedElementBuilder
extends AstVisitor {
    private final ParserConfigInterface config;
    private final ElementScopeStack stack = new ElementScopeStack();

    public static LazyParsedPage process(ParserConfigInterface config, AstNode ast) {
        return (LazyParsedPage)new ScopedElementBuilder(config).go(ast);
    }

    public ScopedElementBuilder(ParserConfigInterface config) {
        this.config = config;
    }

    @Override
    protected Object after(AstNode node, Object result2) {
        return node;
    }

    public void visit(AstNode n) {
        this.stack.append(n);
    }

    public void visit(LazyParsedPage n) {
        this.openScope(ScopeType.PAGE, n);
        this.processScope(n);
        this.closeScope(ScopeType.PAGE, n);
    }

    public void visit(ExternalLink n) {
        this.openScope(ScopeType.WT_INLINE, n);
        n.setTitle(this.processScope(n.getTitle()));
        this.closeScope(ScopeType.WT_INLINE, n);
    }

    public void visit(InternalLink n) {
        this.openScope(ScopeType.WT_INLINE, n);
        this.processScope(n.getTitle());
        this.closeScope(ScopeType.WT_INLINE, n);
    }

    public void visit(ImageLink n) {
        this.openScope(ScopeType.WT_INLINE, n);
        this.processScope(n.getTitle());
        this.closeScope(ScopeType.WT_INLINE, n);
    }

    public void visit(Section n) {
        this.openScope(ScopeType.WT_BLOCK, n);
        n.setTitle(this.processScope(n.getTitle()));
        n.setBody(this.processScope(n.getBody()));
        this.closeScope(ScopeType.WT_BLOCK, n);
    }

    public void visit(Table n) {
        this.openScope(ScopeType.WT_TABLE, n);
        n.setBody(this.processScope(n.getBody()));
        this.closeScope(ScopeType.WT_TABLE, n);
    }

    public void visit(TableCaption n) {
        this.openScope(ScopeType.WT_TABLE_ITEM, n);
        n.setBody(this.processScope(n.getBody()));
        this.closeScope(ScopeType.WT_TABLE_ITEM, n);
    }

    public void visit(TableRow n) {
        this.openScope(ScopeType.WT_TABLE_ITEM, n);
        n.setBody(this.processScope(n.getBody()));
        this.closeScope(ScopeType.WT_TABLE_ITEM, n);
    }

    public void visit(TableHeader n) {
        this.openScope(ScopeType.WT_TABLE_ITEM, n);
        n.setBody(this.processScope(n.getBody()));
        this.closeScope(ScopeType.WT_TABLE_ITEM, n);
    }

    public void visit(TableCell n) {
        this.openScope(ScopeType.WT_TABLE_ITEM, n);
        n.setBody(this.processScope(n.getBody()));
        this.closeScope(ScopeType.WT_TABLE_ITEM, n);
    }

    public void visit(DefinitionList n) {
        this.openScope(ScopeType.WT_BLOCK, n);
        this.iterate(n.getContent());
        this.closeScope(ScopeType.WT_BLOCK, n);
    }

    public void visit(DefinitionTerm n) {
        this.processScope(n);
    }

    public void visit(DefinitionDefinition n) {
        this.processScope(n);
    }

    public void visit(Enumeration n) {
        this.openScope(ScopeType.WT_BLOCK, n);
        this.iterate(n.getContent());
        this.closeScope(ScopeType.WT_BLOCK, n);
    }

    public void visit(EnumerationItem n) {
        this.processScope(n);
    }

    public void visit(Itemization n) {
        this.openScope(ScopeType.WT_BLOCK, n);
        this.iterate(n.getContent());
        this.closeScope(ScopeType.WT_BLOCK, n);
    }

    public void visit(ItemizationItem n) {
        this.processScope(n);
    }

    public void visit(SemiPre n) {
        this.openScope(ScopeType.WT_BLOCK, n);
        this.iterate(n.getContent());
        this.closeScope(ScopeType.WT_BLOCK, n);
    }

    public void visit(SemiPreLine n) {
        this.processScope(n);
    }

    public void visit(XmlElementEmpty n) {
        if (n instanceof IntermediateTag || this.config.isXmlElementAllowed(n.getName())) {
            this.stack.append(this.createEmptyElement(n));
        } else {
            this.stack.append(n);
        }
    }

    public void visit(XmlElementOpen n) {
        String name2 = n.getName();
        if (n instanceof IntermediateTag || this.config.isXmlElementAllowed(name2)) {
            if (this.config.isXmlElementEmptyOnly(name2)) {
                this.stack.append(this.createEmptyElement(n));
            } else {
                this.openScope(this.determineElementType(n), n);
            }
        } else {
            this.stack.append(n);
        }
    }

    public void visit(XmlElementClose n) {
        String name2 = n.getName();
        if (n instanceof IntermediateTag || this.config.isXmlElementAllowed(name2)) {
            this.closeScope(this.determineElementType(n), n);
        } else {
            this.stack.append(n);
        }
    }

    private ScopeType determineElementType(NamedXmlElement n) {
        String name2 = n.getName().toLowerCase();
        if (name2.startsWith("@")) {
            name2 = name2.substring(1);
        }
        return this.config.getXmlElementType(name2);
    }

    private void openScope(ScopeType scopeType, AstNode n) {
        this.stack.push(scopeType, n, true);
        if (scopeType.isCloseInline()) {
            this.closeBeforeBlock(scopeType.isCloseSamePred());
            if (scopeType.isReopenClosedInline() && !scopeType.isWikitextScope()) {
                this.reopenClosedInlineScopes();
            }
        }
    }

    private void processScope(ContentNode n) {
        n.setContent(this.processScope(n.getContent()));
    }

    private NodeList processScope(NodeList n) {
        ElementScopeStack.Scope container = this.stack.top();
        this.stack.push(ScopeType.WT_ELEMENT_BODY, n, true);
        ElementScopeStack.Scope current = this.stack.top();
        if (container.getType().isReopenClosedInline()) {
            this.reopenClosedInlineScopes(container.clearClosedInline());
        }
        this.iterate(n);
        while (this.stack.top() != current) {
            ElementScopeStack.Scope s2 = this.stack.top();
            if (s2.getType().isWikitextScope()) {
                throw new FmtInternalLogicError();
            }
            if (s2.getType().isReopen() && container.getType().isPropagateOut()) {
                container.addClosedInline(s2);
            } else if (!s2.getType().isPropagateOut()) {
                container.clearClosedInline();
            }
            this.stack.top().previous().append(this.close(s2));
            this.stack.pop();
        }
        this.stack.pop();
        return current.getContent();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void closeScope(ScopeType scopeType, AstNode n) {
        ElementScopeStack.Scope current = this.stack.top();
        if (scopeType.isWikitextScope()) {
            if (current.getElement() != n || current.getType() != scopeType) {
                throw new FmtInternalLogicError();
            }
            this.stack.pop();
            if (scopeType != ScopeType.PAGE) {
                this.stack.append(n);
            }
            this.reopenClosedInlineScopes(current.getClosedInline());
            return;
        }
        NamedXmlElement closing = (NamedXmlElement)((Object)n);
        if (current.match(closing)) {
            this.stack.pop();
            this.stack.append(this.close(current, (XmlElementClose)n));
            this.reopenClosedInlineScopes(current.getClosedInline());
            return;
        }
        ElementScopeStack.Scope s2 = this.findMatchingOpeningTag(scopeType, current, closing);
        if (s2 == null) {
            if (n instanceof ImTagClose) return;
            this.stack.append(n);
            return;
        }
        ElementScopeStack.Scope from2 = s2;
        while (true) {
            ElementScopeStack.Scope toIncl;
            if ((s2 = s2.next()) == null) {
                toIncl = this.stack.top();
                this.closeScopesBeforeClosingTag(from2, toIncl, (XmlElementClose)n);
                return;
            }
            if (!s2.getType().isWikitextScope()) continue;
            toIncl = s2.previous();
            ElementScopeStack.Scope insert = s2.next();
            this.closeScopesBeforeClosingTag(from2, toIncl, insert);
            s2 = insert;
            from2 = insert.next();
            if (from2 == null) return;
        }
    }

    private void closeBeforeBlock(boolean closeSamePrec) {
        ElementScopeStack.Scope current = this.stack.top();
        boolean isRecordClosed = current.getType().isContinueClosed() || current.getType().isReopenClosedInline();
        ElementScopeStack.Scope i = current;
        while (i.hasPrevious()) {
            NamedXmlElement e;
            ElementScopeStack.Scope s2 = i.previous();
            if (s2.getType().isClosableBeforeBlock()) {
                if (s2.getType().isReopen() && isRecordClosed) {
                    current.addClosedInline(s2);
                }
                s2.previous().append(this.close(s2));
                this.stack.drop(s2);
                continue;
            }
            if (!closeSamePrec || !(current.getElement() instanceof NamedXmlElement) || !s2.match(e = (NamedXmlElement)((Object)current.getElement()))) break;
            s2.previous().append(this.close(s2));
            this.stack.drop(s2);
            break;
        }
    }

    private void closeScopesBeforeClosingTag(ElementScopeStack.Scope from2, ElementScopeStack.Scope toIncl, ElementScopeStack.Scope reopenIn) {
        ElementScopeStack.Scope i = toIncl;
        while (true) {
            if (i.getType().isReopen()) {
                NodeList c = null;
                if (!reopenIn.getContent().isEmpty()) {
                    c = reopenIn.clearContent();
                }
                ElementScopeStack.Scope s2 = this.stack.insertAfter(reopenIn, i.getType(), i.getElement(), false);
                if (c != null) {
                    s2.setContent(c);
                }
            }
            i.previous().append(this.close(i));
            this.stack.drop(i);
            if (i == from2) break;
            i = i.previous();
        }
    }

    private void closeScopesBeforeClosingTag(ElementScopeStack.Scope from2, ElementScopeStack.Scope toIncl, XmlElementClose close_) {
        LinkedList<ElementScopeStack.Scope> reopen = null;
        boolean propagateOut = from2.getType().isPropagateOut();
        ElementScopeStack.Scope i = toIncl;
        while (true) {
            if (i == from2) {
                if (reopen == null) {
                    reopen = i.clearClosedInline();
                }
                if (i.getClosedInline() != null) {
                    reopen.addAll(0, i.getClosedInline());
                }
                if (i.match(close_)) {
                    i.previous().append(this.close(i, close_));
                    break;
                }
                i.previous().append(this.close(i));
                i.previous().append(close_);
                break;
            }
            if (i.getType().isReopen() && propagateOut) {
                if (reopen == null) {
                    reopen = new LinkedList();
                }
                reopen.addFirst(i);
            }
            i.previous().append(this.close(i));
            this.stack.pop();
            i = i.previous();
        }
        this.stack.pop();
        if (from2.getType().isContinueClosed()) {
            this.reopenClosedInlineScopes(reopen);
        }
    }

    private void reopenClosedInlineScopes() {
        ElementScopeStack.Scope current = this.stack.top();
        LinkedList<ElementScopeStack.Scope> closedInline = current.getClosedInline();
        if (closedInline != null) {
            this.reopenClosedInlineScopes(closedInline);
            current.clearClosedInline();
        }
    }

    private void reopenClosedInlineScopes(LinkedList<ElementScopeStack.Scope> closedInline) {
        if (closedInline != null) {
            for (ElementScopeStack.Scope s2 : closedInline) {
                this.stack.push(s2.getType(), s2.getElement(), false);
            }
        }
    }

    private ElementScopeStack.Scope findMatchingOpeningTag(ScopeType scopeType, ElementScopeStack.Scope current, NamedXmlElement closing) {
        if (scopeType.isInlineScope()) {
            return this.findMatchingInlineOpeningTag(scopeType, current, closing);
        }
        if (scopeType.isTableScope()) {
            return this.findMatchingTableOpeningTag(scopeType, current, closing);
        }
        if (scopeType.isBlockScope()) {
            return this.findMatchingBlockOpeningTag(scopeType, current, closing);
        }
        return this.findMatchingSpecialOpeningTag(scopeType, current, closing);
    }

    private ElementScopeStack.Scope findMatchingInlineOpeningTag(ScopeType scopeType, ElementScopeStack.Scope s2, NamedXmlElement closing) {
        while (!s2.getType().isBlockScope()) {
            if ((s2 = s2.previous()).match(closing)) {
                return s2;
            }
            if (s2.hasPrevious()) continue;
        }
        return null;
    }

    private ElementScopeStack.Scope findMatchingTableOpeningTag(ScopeType scopeType, ElementScopeStack.Scope s2, NamedXmlElement closing) {
        do {
            if (!(s2 = s2.previous()).match(closing)) continue;
            return s2;
        } while (s2.hasPrevious());
        return null;
    }

    private ElementScopeStack.Scope findMatchingBlockOpeningTag(ScopeType scopeType, ElementScopeStack.Scope s2, NamedXmlElement closing) {
        while (!s2.getType().isBlockScope()) {
            if ((s2 = s2.previous()).match(closing)) {
                return s2;
            }
            if (s2.hasPrevious()) continue;
        }
        return null;
    }

    private ElementScopeStack.Scope findMatchingSpecialOpeningTag(ScopeType scopeType, ElementScopeStack.Scope s2, NamedXmlElement closing) {
        while (!s2.getType().isTableScope()) {
            if ((s2 = s2.previous()).match(closing)) {
                return s2;
            }
            if (s2.hasPrevious()) continue;
        }
        return null;
    }

    private AstNode close(ElementScopeStack.Scope s2) {
        return this.close(s2, null);
    }

    private AstNode close(ElementScopeStack.Scope s2, AstNode c) {
        XmlElementOpen open2;
        NodeList content = s2.getContent();
        if (s2.getType().dropIfEmpty() && content.isEmpty()) {
            return null;
        }
        if (content.size() == 1) {
            AstNode c0 = content.get(0);
            if (s2.getType().dropIfOnlyWhitespace() && c0.isNodeType(196611) && !s2.isOpen() && c == null) {
                return c0;
            }
        }
        if (s2.getElement() instanceof ImTagOpen) {
            open2 = (ImTagOpen)s2.getElement();
            ImTagClose close2 = (ImTagClose)c;
            return ((ImTagOpen)open2).getType().transform(this.config, (ImTagOpen)open2, close2, content);
        }
        open2 = (XmlElementOpen)s2.getElement();
        XmlElementClose close3 = (XmlElementClose)c;
        return this.createElement(open2, content, close3, s2.isOpen());
    }

    private XmlElement createEmptyElement(XmlElementEmpty empty) {
        return this.createEmptyElement(empty, empty.getXmlAttributes(), true);
    }

    private XmlElement createEmptyElement(XmlElementOpen open2) {
        return this.createEmptyElement(open2, open2.getXmlAttributes(), false);
    }

    private XmlElement createEmptyElement(NamedXmlElement e, NodeList attrs, boolean wasEmpty) {
        XmlElement element2 = new XmlElement(e.getName(), true, attrs, new NodeList());
        if (this.config.isGatherRtData()) {
            Object[] rtd1;
            Object[] rtd0;
            RtData rtd = (RtData)e.getAttribute("RTD");
            if (rtd == null) {
                rtd0 = TextUtils.joinRt(Character.valueOf('<'), e.getName());
                rtd1 = TextUtils.joinRt(wasEmpty ? " />" : Character.valueOf('>'));
            } else {
                rtd0 = rtd.getRts()[0];
                rtd1 = rtd.getRts()[1];
            }
            TextUtils.addRtData(element2, rtd0, rtd1, null);
        }
        return element2;
    }

    private XmlElement createElement(XmlElementOpen open2, NodeList body, XmlElementClose close2, boolean hasOpen) {
        XmlElement e = new XmlElement(open2.getName(), false, open2.getXmlAttributes(), body);
        if (this.config.isGatherRtData()) {
            Object[] oRtd0 = null;
            Object[] oRtd1 = null;
            Object[] cRtd0 = null;
            if (hasOpen) {
                RtData a = (RtData)open2.getAttribute("RTD");
                if (a == null) {
                    oRtd0 = TextUtils.joinRt(Character.valueOf('<'), open2.getName());
                    oRtd1 = TextUtils.joinRt(Character.valueOf('>'));
                } else {
                    oRtd0 = a.getRts()[0];
                    oRtd1 = a.getRts()[1];
                }
            }
            if (close2 != null) {
                RtData b = (RtData)close2.getAttribute("RTD");
                cRtd0 = b != null ? b.getRts()[0] : TextUtils.joinRt("</", open2.getName(), Character.valueOf('>'));
            }
            TextUtils.addRtData(e, oRtd0, oRtd1, cRtd0);
        }
        return e;
    }
}

