/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.lazy.postprocessor;

import de.fau.cs.osr.ptk.common.AstPrinter;
import de.fau.cs.osr.ptk.common.AstVisitor;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.NodeList;
import de.fau.cs.osr.utils.StringUtils;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.sweble.wikitext.lazy.parser.NamedXmlElement;
import org.sweble.wikitext.lazy.parser.XmlElementOpen;
import org.sweble.wikitext.lazy.postprocessor.ScopeType;

public final class ElementScopeStack
extends AstVisitor {
    Scope top = null;

    public Scope top() {
        return this.top;
    }

    public void push(ScopeType type, AstNode n, boolean open2) {
        Scope s2 = new Scope(type, n, open2);
        if (this.top == null) {
            this.top = s2;
        } else {
            this.insertAfter(this.top, s2);
        }
    }

    public Scope insertAfter(Scope i, ScopeType type, AstNode n, boolean open2) {
        return this.insertAfter(i, new Scope(type, n, open2));
    }

    private Scope insertAfter(Scope i, Scope insert) {
        insert.previous = i;
        insert.next = i.next;
        if (i.next != null) {
            i.next.previous = insert;
        }
        i.next = insert;
        if (i == this.top) {
            this.top = insert;
        }
        return insert;
    }

    public Scope drop(Scope s2) {
        if (s2 == this.top) {
            throw new UnsupportedOperationException();
        }
        s2.next.previous = s2.previous;
        if (s2.previous != null) {
            s2.previous.next = s2.next;
        }
        return s2;
    }

    public Scope pop() {
        Scope old = this.top;
        if (this.top == null) {
            throw new NoSuchElementException();
        }
        this.top = this.top.previous();
        if (this.top != null) {
            this.top.next = null;
        }
        return old;
    }

    public void append(AstNode n) {
        this.top().append(n);
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        s2.append("ScopeStack:\n\n");
        int indent = 2;
        Scope i = this.top;
        if (i != null) {
            while (i.hasPrevious()) {
                i = i.previous();
            }
        }
        while (i != null) {
            s2.append(StringUtils.indent(i.toString().trim(), StringUtils.strrep(' ', indent)));
            s2.append("\n\n");
            indent += 2;
            i = i.next();
        }
        return s2.toString();
    }

    public static final class Scope {
        private Scope previous;
        private Scope next;
        private final ScopeType type;
        private final AstNode element;
        private final boolean open;
        private NodeList content = new NodeList();
        private LinkedList<Scope> closedInline;

        public Scope(ScopeType type, AstNode n, boolean open2) {
            this.type = type;
            this.element = n;
            this.open = open2;
        }

        public boolean hasPrevious() {
            return this.previous != null;
        }

        public Scope previous() {
            return this.previous;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Scope next() {
            return this.next;
        }

        public AstNode getElement() {
            return this.element;
        }

        public NodeList getContent() {
            return this.content;
        }

        public ScopeType getType() {
            return this.type;
        }

        public LinkedList<Scope> getClosedInline() {
            return this.closedInline;
        }

        public boolean isOpen() {
            return this.open;
        }

        public void append(AstNode n) {
            this.content.add(n);
        }

        public void addClosedInline(Scope s2) {
            if (this.closedInline == null) {
                this.closedInline = new LinkedList();
            }
            this.closedInline.addFirst(s2);
        }

        public LinkedList<Scope> clearClosedInline() {
            LinkedList<Scope> ci = this.closedInline;
            this.closedInline = null;
            return ci;
        }

        public boolean match(NamedXmlElement otherElement) {
            String on;
            NamedXmlElement e;
            String en;
            return this.element instanceof NamedXmlElement && (en = (e = (NamedXmlElement)((Object)this.element)).getName()).equalsIgnoreCase(on = otherElement.getName());
        }

        public NodeList clearContent() {
            NodeList c = this.content;
            this.content = new NodeList();
            return c;
        }

        public void setContent(NodeList content) {
            this.content = content;
        }

        public String toString() {
            StringBuilder s2 = new StringBuilder();
            s2.append("Node: ");
            s2.append(this.element.getClass().getSimpleName());
            switch (this.element.getNodeType()) {
                case 720936: {
                    s2.append(": <");
                    XmlElementOpen e = (XmlElementOpen)this.element;
                    s2.append(e.getName());
                    if (e.getXmlAttributes() != null && !e.getXmlAttributes().isEmpty()) {
                        s2.append(' ');
                        s2.append(e.getXmlAttributes().toString());
                    }
                    s2.append('>');
                    break;
                }
                case 720934: {
                    s2.append(": </");
                    XmlElementOpen e = (XmlElementOpen)this.element;
                    s2.append(e.getName());
                    s2.append('>');
                    break;
                }
            }
            s2.append("\n");
            s2.append("Type: ");
            s2.append((Object)this.type);
            s2.append("\n");
            if (this.closedInline != null) {
                s2.append("Closed inline: ");
                int j = 0;
                for (Scope scope : this.closedInline) {
                    if (j++ > 0) {
                        s2.append(", ");
                    }
                    s2.append(scope.getElement().getClass().getSimpleName());
                }
                s2.append("\n");
            }
            s2.append("Content:\n");
            String c = AstPrinter.print(this.content);
            c = StringUtils.indent(c.trim(), "  | ");
            s2.append(c);
            s2.append("\n");
            return s2.toString();
        }
    }
}

