/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.lazy.parser;

import de.fau.cs.osr.ptk.common.Warning;
import de.fau.cs.osr.ptk.common.ast.Span;
import org.sweble.wikitext.lazy.parser.WarningSeverity;

public abstract class LazyWarning
extends Warning {
    private static final long serialVersionUID = 1L;
    protected final WarningSeverity severity;

    public LazyWarning(Span span2, WarningSeverity severity, String origin, String message) {
        super(span2, origin, message);
        this.severity = severity;
    }

    public LazyWarning(Span span2, WarningSeverity severity, Class<?> origin, String message) {
        super(span2, origin, message);
        this.severity = severity;
    }

    public WarningSeverity getSeverity() {
        return this.severity;
    }

    @Override
    public String toString() {
        String span2 = this.spanToString();
        String message = this.messageToString();
        String severity = this.severityToString();
        return "Warning (" + severity + "): " + span2 + " : " + message;
    }

    protected String severityToString() {
        String severity = "-";
        if (this.getSeverity() != null) {
            severity = this.getSeverity().toString().toLowerCase();
        }
        return severity;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.severity == null ? 0 : this.severity.hashCode());
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LazyWarning other = (LazyWarning)obj;
        return this.severity == other.severity;
    }
}

