/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.lazy.parser;

public enum ImageViewFormat {
    UNRESTRAINED{

        @Override
        public String asKeyword() {
            return "";
        }

        @Override
        public int priority() {
            return 0;
        }

        @Override
        public boolean isFramed() {
            return false;
        }
    }
    ,
    FRAMELESS{

        @Override
        public String asKeyword() {
            return "frameless";
        }

        @Override
        public int priority() {
            return 1;
        }

        @Override
        public boolean isFramed() {
            return false;
        }
    }
    ,
    THUMBNAIL{

        @Override
        public String asKeyword() {
            return "thumb";
        }

        @Override
        public int priority() {
            return 2;
        }

        @Override
        public boolean isFramed() {
            return true;
        }
    }
    ,
    FRAME{

        @Override
        public String asKeyword() {
            return "frame";
        }

        @Override
        public int priority() {
            return 3;
        }

        @Override
        public boolean isFramed() {
            return true;
        }
    };

    private static final Object[] formatMap;

    public abstract String asKeyword();

    public abstract int priority();

    public abstract boolean isFramed();

    public static ImageViewFormat which(String s2) {
        if (s2 == null) {
            throw new NullPointerException();
        }
        s2 = s2.trim().toLowerCase();
        for (int i = 0; i < formatMap.length; i += 2) {
            String f = (String)formatMap[i];
            if (!f.equals(s2)) continue;
            return (ImageViewFormat)((Object)formatMap[i + 1]);
        }
        return null;
    }

    public ImageViewFormat combine(ImageViewFormat other) {
        return this.priority() > other.priority() ? this : other;
    }

    static {
        formatMap = new Object[]{"frameless", FRAMELESS, "thumb", THUMBNAIL, "thumbnail", THUMBNAIL, "frame", FRAME};
    }
}

