/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.lazy.encval;

import de.fau.cs.osr.ptk.common.EntityMap;
import de.fau.cs.osr.ptk.common.ast.Location;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.sweble.wikitext.lazy.encval.IllegalCodePoint;
import org.sweble.wikitext.lazy.encval.IllegalCodePointType;

public class EncodingValidatorLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0};
    private static final String ZZ_CMAP_PACKED = "\t\t\u0001\u0002\u0001\u0002\u0002\t\u0001\u0002\f\te\u0002\u0001\t\ud780\u0002?\u0001\u0001\u0004?\u0001\u0001\u0004?\u0001\u0001\u0004?\u0001\u0001\u0004?\u0001\u0001\u0004?\u0001\u0001\u0004?\u0001\u0001\u0004?\u0001\u0001\u0004?\u0001\u0001\u0004?\u0001\u0001\u0004?\u0001\u0001\u0004?\u0001\u0001\u0004?\u0001\u0001\u0004?\u0001\u0001\u0004?\u0007\u0001\b?\u0007\u0001\b\u03fe\u0000\u0002\u0005\u1900\u0006\u04d0\u0002 \u0003\u020e\u0002\u0002\u0003";
    private static final char[] ZZ_CMAP = EncodingValidatorLexer.zzUnpackCMap("\t\t\u0001\u0002\u0001\u0002\u0002\t\u0001\u0002\f\te\u0002\u0001\t\ud780\u0002?\u0001\u0001\u0004?\u0001\u0001\u0004?\u0001\u0001\u0004?\u0001\u0001\u0004?\u0001\u0001\u0004?\u0001\u0001\u0004?\u0001\u0001\u0004?\u0001\u0001\u0004?\u0001\u0001\u0004?\u0001\u0001\u0004?\u0001\u0001\u0004?\u0001\u0001\u0004?\u0001\u0001\u0004?\u0001\u0001\u0004?\u0007\u0001\b?\u0007\u0001\b\u03fe\u0000\u0002\u0005\u1900\u0006\u04d0\u0002 \u0003\u020e\u0002\u0002\u0003");
    private static final int[] ZZ_ACTION = EncodingValidatorLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0001\u0000\u0002\u0001\u0001\u0002\u0001\u0001\u0001\u0003\u0002\u0001\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0002\u0001\u0003";
    private static final int[] ZZ_ROWMAP = EncodingValidatorLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\n\u0000\u0014\u0000\n\u0000\u001e\u0000\n\u0000(\u00002\u0000\n\u0000<\u0000<\u0000<\u0000<";
    private static final int[] ZZ_TRANS = EncodingValidatorLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u0002\u0001\u0003\u0001\u0002\u0001\u0004\u0001\u0005\u0001\u0002\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0001\n\u0004\u0000\u0001\n\u0005\u0000\u0004\u000b\u0001\u0000\u0004\u000b\u0001\u0000\u0004\u000b\u0001\f\u0004\u000b\u0001\r\u0004\u000b\u0001\r\u0004\u000b\u0001\r\u0004\u000b\u0001\f\u0004\u000b\n\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = EncodingValidatorLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0001\u0000\b\u0001\u0004\t";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    private EntityMap entityMap = null;
    private StringBuilder text = new StringBuilder();
    private String file;

    private static int[] zzUnpackAction() {
        int[] result2 = new int[13];
        int offset = 0;
        offset = EncodingValidatorLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result2);
        return result2;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result2) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count2 = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result2[j++] = value;
            } while (--count2 > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result2 = new int[13];
        int offset = 0;
        offset = EncodingValidatorLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result2);
        return result2;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result2) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result2[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result2 = new int[70];
        int offset = 0;
        offset = EncodingValidatorLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result2);
        return result2;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result2) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count2 = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result2[j++] = --value;
            } while (--count2 > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result2 = new int[13];
        int offset = 0;
        offset = EncodingValidatorLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result2);
        return result2;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result2) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count2 = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result2[j++] = value;
            } while (--count2 > 0);
        }
        return j;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getFile() {
        return this.file;
    }

    public void setEntityMap(EntityMap entityMap) {
        this.entityMap = entityMap;
    }

    public EntityMap getEntityMap() {
        return this.entityMap;
    }

    private void wrapIllegalCodePoint(int line, int column, String codePoint, IllegalCodePointType type) {
        IllegalCodePoint p = new IllegalCodePoint(codePoint, type);
        p.setNativeLocation(new Location(this.file, line, column));
        int id = this.entityMap.registerEntity(p);
        this.text.append('\ue000');
        this.text.append(id);
        this.text.append('\ue001');
    }

    public String getWikitext() {
        return this.text.toString();
    }

    public EncodingValidatorLexer(Reader in) {
        this.zzReader = in;
    }

    public EncodingValidatorLexer(InputStream in) {
        this(new InputStreamReader(in));
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map2 = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 96) {
            int count2 = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map2[j++] = value;
            } while (--count2 > 0);
        }
        return map2;
    }

    private boolean zzRefill() throws IOException {
        int numRead;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] newBuffer = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) > 0) {
            this.zzEndRead += numRead;
            return false;
        }
        if (numRead == 0) {
            int c = this.zzReader.read();
            if (c == -1) {
                return true;
            }
            this.zzBuffer[this.zzEndRead++] = (char)c;
            return false;
        }
        return true;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader2) {
        this.zzReader = reader2;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzEOFDone = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public Object yylex() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block19: while (true) {
            int zzInput;
            int zzCurrentPosL;
            int zzMarkedPosL = this.zzMarkedPos;
            boolean zzR = false;
            block20: for (zzCurrentPosL = this.zzStartRead; zzCurrentPosL < zzMarkedPosL; ++zzCurrentPosL) {
                switch (zzBufferL[zzCurrentPosL]) {
                    case '\u000b': 
                    case '\f': 
                    case '\u0085': 
                    case '\u2028': 
                    case '\u2029': {
                        ++this.yyline;
                        this.yycolumn = 0;
                        zzR = false;
                        continue block20;
                    }
                    case '\r': {
                        ++this.yyline;
                        this.yycolumn = 0;
                        zzR = true;
                        continue block20;
                    }
                    case '\n': {
                        if (zzR) {
                            zzR = false;
                            continue block20;
                        }
                        ++this.yyline;
                        this.yycolumn = 0;
                        continue block20;
                    }
                    default: {
                        zzR = false;
                        ++this.yycolumn;
                    }
                }
            }
            if (zzR) {
                boolean zzPeek;
                if (zzMarkedPosL < zzEndReadL) {
                    zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                } else if (this.zzAtEOF) {
                    zzPeek = false;
                } else {
                    boolean eof = this.zzRefill();
                    zzEndReadL = this.zzEndRead;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    if (eof) {
                        zzPeek = false;
                    } else {
                        boolean bl = zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                    }
                }
                if (zzPeek) {
                    --this.yyline;
                }
            }
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL[zzCurrentPosL++];
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL[zzCurrentPosL++];
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                int zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 2: {
                    this.wrapIllegalCodePoint(this.yyline, this.yycolumn, this.yytext(), IllegalCodePointType.NON_CHARACTER);
                }
                case 7: {
                    continue block19;
                }
                case 6: {
                    String match = this.yytext();
                    this.wrapIllegalCodePoint(this.yyline, this.yycolumn, match.substring(0, 1), IllegalCodePointType.ISOLATED_SURROGATE);
                    this.text.append(match.substring(1));
                }
                case 8: {
                    continue block19;
                }
                case 3: {
                    this.wrapIllegalCodePoint(this.yyline, this.yycolumn, this.yytext(), IllegalCodePointType.PRIVATE_USE_CHARACTER);
                }
                case 9: {
                    continue block19;
                }
                case 1: {
                    this.text.append(this.yytext());
                }
                case 10: {
                    continue block19;
                }
                case 4: {
                    this.wrapIllegalCodePoint(this.yyline, this.yycolumn, this.yytext(), IllegalCodePointType.CONTROL_CHARACTER);
                }
                case 11: {
                    continue block19;
                }
                case 5: {
                    String match = this.yytext();
                    this.text.append(match.substring(0, 1));
                    this.wrapIllegalCodePoint(this.yyline, this.yycolumn + 1, match.substring(1), IllegalCodePointType.ISOLATED_SURROGATE);
                }
                case 12: {
                    continue block19;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return null;
            }
            this.zzScanError(1);
        }
    }
}

