/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.utils;

import de.fau.cs.osr.utils.FmtIllegalArgumentException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.sweble.wikitext.engine.ParserFunctionBase;
import org.sweble.wikitext.engine.TagExtensionBase;
import org.sweble.wikitext.engine.config.Interwiki;
import org.sweble.wikitext.engine.config.MagicWord;
import org.sweble.wikitext.engine.config.Namespace;
import org.sweble.wikitext.engine.config.WikiConfigurationInterface;
import org.sweble.wikitext.engine.ext.ParserFunctionFullPagename;
import org.sweble.wikitext.engine.ext.ParserFunctionFullurl;
import org.sweble.wikitext.engine.ext.ParserFunctionIf;
import org.sweble.wikitext.engine.ext.ParserFunctionIfError;
import org.sweble.wikitext.engine.ext.ParserFunctionIfeq;
import org.sweble.wikitext.engine.ext.ParserFunctionLc;
import org.sweble.wikitext.engine.ext.ParserFunctionNamespace;
import org.sweble.wikitext.engine.ext.ParserFunctionNs;
import org.sweble.wikitext.engine.ext.ParserFunctionSwitch;
import org.sweble.wikitext.engine.ext.TagExtensionMath;
import org.sweble.wikitext.engine.ext.TagExtensionNoWiki;
import org.sweble.wikitext.engine.ext.TagExtensionPre;
import org.sweble.wikitext.engine.ext.TagExtensionRef;
import org.sweble.wikitext.engine.ext.UnimplementedParserFunction;
import org.sweble.wikitext.engine.utils.AdaptedInterwiki;
import org.sweble.wikitext.engine.utils.AdaptedMagicWord;
import org.sweble.wikitext.engine.utils.AdaptedNamespace;
import org.sweble.wikitext.engine.utils.AdaptedSimpleWikiConfiguration;
import org.sweble.wikitext.engine.utils.EntityReferences;
import org.sweble.wikitext.engine.utils.ObjectFactory;
import org.sweble.wikitext.lazy.LinkTargetException;
import org.sweble.wikitext.lazy.LinkTargetParser;
import org.sweble.wikitext.lazy.ParserConfigInterface;
import org.sweble.wikitext.lazy.utils.SimpleParserConfig;

public class SimpleWikiConfiguration
extends SimpleParserConfig
implements WikiConfigurationInterface {
    private static final long serialVersionUID = 1L;
    private final HashMap<Integer, Namespace> namespacesById = new HashMap();
    private final HashMap<String, Namespace> namespacesByAlias = new HashMap();
    private Namespace defaultNamespace = null;
    private Namespace templateNamespace = null;
    private final HashMap<String, Interwiki> interwikiMap = new HashMap();
    private Interwiki localInterwiki = null;
    private final HashMap<String, MagicWord> magicWords = new HashMap();
    private final HashMap<String, MagicWord> magicWordsByAlias = new HashMap();
    private final HashMap<String, ParserFunctionBase> parserFunctions = new HashMap();
    private final HashMap<String, TagExtensionBase> tagExtensions = new HashMap();

    public SimpleWikiConfiguration() {
        this.staticSetup();
    }

    public SimpleWikiConfiguration(String xmlConfig) throws FileNotFoundException, JAXBException {
        String file = xmlConfig.trim();
        if (file.startsWith("classpath:")) {
            file = file.substring(10);
            InputStream in = this.getClass().getResourceAsStream(file);
            if (in == null) {
                throw new FileNotFoundException(xmlConfig);
            }
            this.deserialize(in);
        } else {
            this.deserialize(new FileInputStream(file));
        }
        this.staticSetup();
    }

    private void staticSetup() {
        this.addParserFunction(new UnimplementedParserFunction("CURRENTDAY2"));
        this.addParserFunction(new UnimplementedParserFunction("CURRENTDAYNAME"));
        this.addParserFunction(new UnimplementedParserFunction("CURRENTDAY"));
        this.addParserFunction(new UnimplementedParserFunction("CURRENTDOW"));
        this.addParserFunction(new UnimplementedParserFunction("CURRENTHOUR"));
        this.addParserFunction(new UnimplementedParserFunction("CURRENTMONTHABBREV"));
        this.addParserFunction(new UnimplementedParserFunction("CURRENTMONTHNAMEGEN"));
        this.addParserFunction(new UnimplementedParserFunction("CURRENTMONTHNAME"));
        this.addParserFunction(new UnimplementedParserFunction("CURRENTMONTH"));
        this.addParserFunction(new UnimplementedParserFunction("CURRENTTIMESTAMP"));
        this.addParserFunction(new UnimplementedParserFunction("CURRENTTIME"));
        this.addParserFunction(new UnimplementedParserFunction("CURRENTWEEK"));
        this.addParserFunction(new UnimplementedParserFunction("CURRENTYEAR"));
        this.addParserFunction(new UnimplementedParserFunction("LOCALDAY2"));
        this.addParserFunction(new UnimplementedParserFunction("LOCALDAYNAME"));
        this.addParserFunction(new UnimplementedParserFunction("LOCALDAY"));
        this.addParserFunction(new UnimplementedParserFunction("LOCALDOW"));
        this.addParserFunction(new UnimplementedParserFunction("LOCALHOUR"));
        this.addParserFunction(new UnimplementedParserFunction("LOCALMONTHABBREV"));
        this.addParserFunction(new UnimplementedParserFunction("LOCALMONTHNAMEGEN"));
        this.addParserFunction(new UnimplementedParserFunction("LOCALMONTHNAME"));
        this.addParserFunction(new UnimplementedParserFunction("LOCALMONTH"));
        this.addParserFunction(new UnimplementedParserFunction("LOCALTIMESTAMP"));
        this.addParserFunction(new UnimplementedParserFunction("LOCALTIME"));
        this.addParserFunction(new UnimplementedParserFunction("LOCALWEEK"));
        this.addParserFunction(new UnimplementedParserFunction("LOCALYEAR"));
        this.addParserFunction(new UnimplementedParserFunction("BASEPAGENAMEE"));
        this.addParserFunction(new UnimplementedParserFunction("BASEPAGENAME"));
        this.addParserFunction(new UnimplementedParserFunction("FULLPAGENAMEE"));
        this.addParserFunction(new ParserFunctionFullPagename());
        this.addParserFunction(new UnimplementedParserFunction("PAGENAMEE"));
        this.addParserFunction(new UnimplementedParserFunction("PAGENAME"));
        this.addParserFunction(new UnimplementedParserFunction("SUBJECTPAGENAMEE"));
        this.addParserFunction(new UnimplementedParserFunction("SUBJECTPAGENAME"));
        this.addParserFunction(new UnimplementedParserFunction("SUBPAGENAMEE"));
        this.addParserFunction(new UnimplementedParserFunction("SUBPAGENAME"));
        this.addParserFunction(new UnimplementedParserFunction("TALKPAGENAMEE"));
        this.addParserFunction(new UnimplementedParserFunction("TALKPAGENAME"));
        this.addParserFunction(new UnimplementedParserFunction("ARTICLESPACE"));
        this.addParserFunction(new UnimplementedParserFunction("NAMESPACEE"));
        this.addParserFunction(new ParserFunctionNamespace());
        this.addParserFunction(new UnimplementedParserFunction("SUBJECTSPACEE"));
        this.addParserFunction(new UnimplementedParserFunction("SUBJECTSPACE"));
        this.addParserFunction(new UnimplementedParserFunction("TALKSPACEE"));
        this.addParserFunction(new UnimplementedParserFunction("TALKSPACE"));
        this.addParserFunction(new UnimplementedParserFunction("NUMBERINGROUP"));
        this.addParserFunction(new UnimplementedParserFunction("NUMBEROFACTIVEUSERS"));
        this.addParserFunction(new UnimplementedParserFunction("NUMBEROFADMINS"));
        this.addParserFunction(new UnimplementedParserFunction("NUMBEROFARTICLES"));
        this.addParserFunction(new UnimplementedParserFunction("NUMBEROFEDITS"));
        this.addParserFunction(new UnimplementedParserFunction("NUMBEROFFILES"));
        this.addParserFunction(new UnimplementedParserFunction("NUMBEROFPAGES"));
        this.addParserFunction(new UnimplementedParserFunction("NUMBEROFUSERS"));
        this.addParserFunction(new UnimplementedParserFunction("NUMBEROFVIEWS"));
        this.addParserFunction(new UnimplementedParserFunction("NUMINGROUP"));
        this.addParserFunction(new UnimplementedParserFunction("PAGESINCAT"));
        this.addParserFunction(new UnimplementedParserFunction("PAGESINCATEGORY"));
        this.addParserFunction(new UnimplementedParserFunction("PAGESINNAMESPACE"));
        this.addParserFunction(new UnimplementedParserFunction("PAGESINNS"));
        this.addParserFunction(new UnimplementedParserFunction("PAGESIZE"));
        this.addParserFunction(new UnimplementedParserFunction("CONTENTLANGUAGE"));
        this.addParserFunction(new UnimplementedParserFunction("CONTENTLANG"));
        this.addParserFunction(new UnimplementedParserFunction("CURRENTVERSION"));
        this.addParserFunction(new UnimplementedParserFunction("DEFAULTCATEGORYSORT"));
        this.addParserFunction(new UnimplementedParserFunction("DEFAULTSORT"));
        this.addParserFunction(new UnimplementedParserFunction("DEFAULTSORTKEY"));
        this.addParserFunction(new UnimplementedParserFunction("DIRECTIONMARK"));
        this.addParserFunction(new UnimplementedParserFunction("DIRMARK"));
        this.addParserFunction(new UnimplementedParserFunction("DISPLAYTITLE"));
        this.addParserFunction(new UnimplementedParserFunction("PROTECTIONLEVEL"));
        this.addParserFunction(new UnimplementedParserFunction("REVISIONDAY2"));
        this.addParserFunction(new UnimplementedParserFunction("REVISIONDAY"));
        this.addParserFunction(new UnimplementedParserFunction("REVISIONID"));
        this.addParserFunction(new UnimplementedParserFunction("REVISIONMONTH"));
        this.addParserFunction(new UnimplementedParserFunction("REVISIONTIMESTAMP"));
        this.addParserFunction(new UnimplementedParserFunction("REVISIONUSER"));
        this.addParserFunction(new UnimplementedParserFunction("REVISIONYEAR"));
        this.addParserFunction(new UnimplementedParserFunction("SCRIPTPATH"));
        this.addParserFunction(new UnimplementedParserFunction("SERVERNAME"));
        this.addParserFunction(new UnimplementedParserFunction("SERVER"));
        this.addParserFunction(new UnimplementedParserFunction("SITENAME"));
        this.addParserFunction(new UnimplementedParserFunction("STYLEPATH"));
        this.addParserFunction(new ParserFunctionNs());
        this.addParserFunction(new UnimplementedParserFunction("nse"));
        this.addParserFunction(new UnimplementedParserFunction("#dateformat"));
        this.addParserFunction(new UnimplementedParserFunction("#formatdate"));
        this.addParserFunction(new UnimplementedParserFunction("formatnum"));
        this.addParserFunction(new UnimplementedParserFunction("grammar"));
        this.addParserFunction(new ParserFunctionLc());
        this.addParserFunction(new UnimplementedParserFunction("lcfirst"));
        this.addParserFunction(new UnimplementedParserFunction("padleft"));
        this.addParserFunction(new UnimplementedParserFunction("padright"));
        this.addParserFunction(new UnimplementedParserFunction("plural"));
        this.addParserFunction(new UnimplementedParserFunction("uc"));
        this.addParserFunction(new UnimplementedParserFunction("ucfirst"));
        this.addParserFunction(new UnimplementedParserFunction("anchorencode"));
        this.addParserFunction(new UnimplementedParserFunction("filepath"));
        this.addParserFunction(new ParserFunctionFullurl());
        this.addParserFunction(new UnimplementedParserFunction("localurl"));
        this.addParserFunction(new UnimplementedParserFunction("urlencode"));
        this.addParserFunction(new UnimplementedParserFunction("#language"));
        this.addParserFunction(new UnimplementedParserFunction("#special"));
        this.addParserFunction(new UnimplementedParserFunction("#tag"));
        this.addParserFunction(new UnimplementedParserFunction("int"));
        this.addParserFunction(new UnimplementedParserFunction("#expr"));
        this.addParserFunction(new ParserFunctionIf());
        this.addParserFunction(new ParserFunctionIfeq());
        this.addParserFunction(new ParserFunctionIfError());
        this.addParserFunction(new UnimplementedParserFunction("#ifexpr"));
        this.addParserFunction(new UnimplementedParserFunction("#ifexist"));
        this.addParserFunction(new UnimplementedParserFunction("#rel2abs"));
        this.addParserFunction(new ParserFunctionSwitch());
        this.addParserFunction(new UnimplementedParserFunction("#time"));
        this.addParserFunction(new UnimplementedParserFunction("#timel"));
        this.addParserFunction(new UnimplementedParserFunction("#titleparts"));
        this.addTagExtension(new TagExtensionMath());
        this.addTagExtension(new TagExtensionNoWiki());
        this.addTagExtension(new TagExtensionPre());
        this.addTagExtension(new TagExtensionRef());
    }

    @Override
    public boolean isRedirectKeyword(String keyword) {
        MagicWord mw = this.magicWords.get("redirect");
        if (mw == null) {
            return false;
        }
        return mw.hasAlias(keyword);
    }

    public Interwiki addInterwiki(Interwiki interwiki) {
        if (this.interwikiMap.containsKey(interwiki.getPrefix())) {
            throw new FmtIllegalArgumentException("An interwiki with prefix `%s' already exists", interwiki.getPrefix());
        }
        this.interwikiMap.put(interwiki.getPrefix(), interwiki);
        return interwiki;
    }

    public void setLocalInterwiki(Interwiki localInterwiki) {
        this.localInterwiki = localInterwiki;
    }

    public Collection<Interwiki> getInterwikis() {
        return Collections.unmodifiableCollection(this.interwikiMap.values());
    }

    @Override
    public Interwiki getInterwiki(String prefix) {
        return this.interwikiMap.get(prefix);
    }

    @Override
    public Interwiki getLocalInterwiki() {
        return this.localInterwiki;
    }

    public Namespace addNamespace(Namespace ns) {
        if (this.namespacesById.containsKey(ns.getId())) {
            throw new FmtIllegalArgumentException("A namespace with id `%2$d' already exists: `%1$s'", ns.getName(), ns.getId());
        }
        if (this.namespacesByAlias.containsKey(ns.getName().toLowerCase())) {
            throw new FmtIllegalArgumentException("A namespace with name `%1$s' already exists", ns.getName());
        }
        for (String alias : ns.getAliases()) {
            if (!this.namespacesByAlias.containsKey(alias.toLowerCase())) continue;
            throw new FmtIllegalArgumentException("A namespace with alias `%2$s' already exists: `%1$s'", ns.getName(), alias);
        }
        this.namespacesById.put(ns.getId(), ns);
        this.namespacesByAlias.put(ns.getName().toLowerCase(), ns);
        for (String alias : ns.getAliases()) {
            this.namespacesByAlias.put(alias.toLowerCase(), ns);
        }
        return ns;
    }

    public boolean isDefaultNamespaceSet() {
        return this.defaultNamespace != null;
    }

    public void setDefaultNamespace(Namespace defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    public void setTemplateNamespace(Namespace templateNamespace) {
        this.templateNamespace = templateNamespace;
    }

    public Collection<Namespace> getNamespaces() {
        return Collections.unmodifiableCollection(this.namespacesById.values());
    }

    @Override
    public Namespace getNamespace(String name2) {
        return this.namespacesByAlias.get(name2.toLowerCase());
    }

    @Override
    public Namespace getNamespace(int id) {
        return this.namespacesById.get(id);
    }

    @Override
    public Namespace getDefaultNamespace() {
        if (this.defaultNamespace == null) {
            throw new UnsupportedOperationException("The default namespace is not set");
        }
        return this.defaultNamespace;
    }

    @Override
    public Namespace getTemplateNamespace() {
        if (this.templateNamespace == null) {
            throw new UnsupportedOperationException("The template namespace is not set");
        }
        return this.templateNamespace;
    }

    public MagicWord addMagicWord(MagicWord magicWord) {
        this.magicWords.put(magicWord.getName(), magicWord);
        this.magicWordsByAlias.put(magicWord.getName().toLowerCase(), magicWord);
        for (String alias : magicWord.getAliases()) {
            this.magicWordsByAlias.put(alias.toLowerCase(), magicWord);
        }
        return magicWord;
    }

    public Collection<MagicWord> getMagicWords() {
        return Collections.unmodifiableCollection(this.magicWordsByAlias.values());
    }

    @Override
    public MagicWord getMagicWord(String name2) {
        return this.magicWordsByAlias.get(name2.toLowerCase());
    }

    public ParserFunctionBase addParserFunction(ParserFunctionBase pfn) {
        if (this.parserFunctions.containsKey(pfn.getName())) {
            throw new FmtIllegalArgumentException("A parser function with name `%s' already exists", pfn.getName());
        }
        this.parserFunctions.put(pfn.getName().toLowerCase(), pfn);
        return pfn;
    }

    @Override
    public ParserFunctionBase getParserFunction(String name2) {
        return this.parserFunctions.get(name2.toLowerCase());
    }

    public TagExtensionBase addTagExtension(TagExtensionBase te) {
        if (this.tagExtensions.containsKey(te.getName())) {
            throw new FmtIllegalArgumentException("A tag extensions with name `%s' already exists", te.getName());
        }
        this.tagExtensions.put(te.getName(), te);
        return te;
    }

    @Override
    public TagExtensionBase getTagExtension(String name2) {
        return this.tagExtensions.get(name2);
    }

    @Override
    public Collection<TagExtensionBase> getTagExtensions() {
        return this.tagExtensions.values();
    }

    @Override
    public HashSet<String> getAllowedHtmlTags() {
        return new HashSet<String>(Arrays.asList("abbr", "b", "big", "blockquote", "br", "caption", "center", "cite", "code", "dd", "del", "div", "dl", "dt", "em", "font", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "ins", "li", "ol", "p", "pre", "rb", "rp", "rt", "ruby", "s", "small", "span", "strike", "strong", "sub", "sup", "table", "td", "th", "tr", "tt", "u", "ul", "var"));
    }

    @Override
    public HashSet<String> getEmptyOnlyHtmlTags() {
        return new HashSet<String>(Arrays.asList("area", "base", "basefont", "br", "col", "frame", "hr", "img", "input", "isindex", "link", "meta", "param"));
    }

    @Override
    public HashSet<String> getPropagatableHtmlTags() {
        return new HashSet<String>(Arrays.asList("b", "big", "del", "em", "i", "ins", "strong", "s", "small", "span", "strike", "strong", "sub", "sup", "tt", "u"));
    }

    @Override
    public String getWikiUrl() {
        return "http://localhost/wiki";
    }

    @Override
    public boolean isValidXmlEntityRef(String name2) {
        return EntityReferences.resolve(name2) != null;
    }

    @Override
    public boolean isMagicWord(String word) {
        return this.getMagicWord(word) != null;
    }

    @Override
    public String getInternalLinkPrefixPattern() {
        return "";
    }

    @Override
    public ParserConfigInterface.TargetType classifyTarget(String target) {
        Namespace ns2;
        LinkTargetParser ltp = new LinkTargetParser();
        try {
            ltp.parse(this, target);
        }
        catch (LinkTargetException e) {
            return ParserConfigInterface.TargetType.INVALID;
        }
        String ns = ltp.getNamespace();
        if (ns != null && (ns2 = this.getNamespace(ns)).isFileNs()) {
            return ParserConfigInterface.TargetType.IMAGE;
        }
        return ParserConfigInterface.TargetType.PAGE;
    }

    @Override
    public boolean isNamespace(String nsName) {
        return this.getNamespace(nsName) != null;
    }

    @Override
    public boolean isInterwikiName(String iwName) {
        return this.getInterwiki(iwName) != null;
    }

    @Override
    public boolean isLocalInterwikiName(String iwName) {
        Interwiki iw = this.getInterwiki(iwName);
        if (iw == null) {
            throw new FmtIllegalArgumentException("Unknown interwiki prefix: `%s'", iwName);
        }
        return iw.isLocal();
    }

    @Override
    public boolean isValidExtensionTagName(String name2) {
        return this.getTagExtension(name2) != null;
    }

    @Override
    public String resolveXmlEntity(String name2) {
        return EntityReferences.resolve(name2);
    }

    public String serialize() throws JAXBException {
        ObjectFactory of = new ObjectFactory();
        AdaptedSimpleWikiConfiguration aswc = of.createAdaptedSimpleWikiConfiguration();
        aswc.setNamespaces(of.createAdaptedSimpleWikiConfigurationNamespaces());
        for (Namespace ns : this.getNamespaces()) {
            AdaptedNamespace ans = of.createAdaptedNamespace();
            ans.setId(ns.getId());
            ans.setName(ns.getName());
            ans.setCanonical(ns.getCanonical());
            ans.setIsFileNs(ns.isFileNs());
            ans.setSubpages(ns.isSubpages());
            ans.setAliases(of.createAdaptedNamespaceAliases());
            ans.getAliases().getAlias().addAll(ns.getAliases());
            aswc.getNamespaces().getNamespace().add(ans);
        }
        try {
            int id = this.getDefaultNamespace().getId();
            aswc.getNamespaces().setDefaultNamespace(BigInteger.valueOf(id));
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            int id = this.getTemplateNamespace().getId();
            aswc.getNamespaces().setTemplateNamespace(BigInteger.valueOf(id));
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        aswc.setInterwikiLinks(of.createAdaptedSimpleWikiConfigurationInterwikiLinks());
        for (Interwiki iw : this.getInterwikis()) {
            AdaptedInterwiki aiw = of.createAdaptedInterwiki();
            aiw.setPrefix(iw.getPrefix());
            aiw.setUrl(iw.getUrl());
            aiw.setLocal(iw.isLocal());
            aiw.setTrans(iw.isTrans());
            aswc.getInterwikiLinks().getInterwiki().add(aiw);
        }
        aswc.setMagicWords(of.createAdaptedSimpleWikiConfigurationMagicWords());
        for (MagicWord mw : this.getMagicWords()) {
            AdaptedMagicWord amw = of.createAdaptedMagicWord();
            amw.setName(mw.getName());
            amw.setCaseSensitive(mw.isCaseSensitive());
            amw.setAliases(of.createAdaptedMagicWordAliases());
            amw.getAliases().getAlias().addAll(mw.getAliases());
            aswc.getMagicWords().getMagicWord().add(amw);
        }
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{AdaptedSimpleWikiConfiguration.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        StringWriter w = new StringWriter();
        m.marshal((Object)aswc, (Writer)w);
        return w.toString();
    }

    public void deserialize(InputStream in) throws JAXBException {
        BigInteger tmplNs;
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{AdaptedSimpleWikiConfiguration.class});
        Unmarshaller m = context.createUnmarshaller();
        AdaptedSimpleWikiConfiguration swc = (AdaptedSimpleWikiConfiguration)m.unmarshal(in);
        for (AdaptedNamespace ns : swc.getNamespaces().getNamespace()) {
            this.addNamespace(new Namespace(ns.getId(), ns.getName(), ns.getCanonical(), ns.isSubpages(), ns.isIsFileNs(), ns.getAliases().getAlias()));
        }
        BigInteger defNs = swc.getNamespaces().getDefaultNamespace();
        if (defNs != null) {
            this.defaultNamespace = this.getNamespace(defNs.intValue());
        }
        if ((tmplNs = swc.getNamespaces().getTemplateNamespace()) != null) {
            this.templateNamespace = this.getNamespace(tmplNs.intValue());
        }
        for (AdaptedInterwiki iw : swc.getInterwikiLinks().getInterwiki()) {
            this.addInterwiki(new Interwiki(iw.getPrefix(), iw.getUrl(), iw.isLocal(), iw.isTrans()));
        }
        for (AdaptedMagicWord mw : swc.getMagicWords().getMagicWord()) {
            this.addMagicWord(new MagicWord(mw.getName(), mw.isCaseSensitive(), mw.getAliases().getAlias()));
        }
    }
}

