/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.utils;

import de.fau.cs.osr.ptk.common.PrinterBase;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.sweble.wikitext.engine.log.CompilerLog;
import org.sweble.wikitext.engine.log.IllegalNameException;
import org.sweble.wikitext.engine.log.ParseException;
import org.sweble.wikitext.engine.log.ParserLog;
import org.sweble.wikitext.engine.log.PostprocessorLog;
import org.sweble.wikitext.engine.log.PpResolverLog;
import org.sweble.wikitext.engine.log.PreprocessorLog;
import org.sweble.wikitext.engine.log.ResolveRedirectLog;
import org.sweble.wikitext.engine.log.ResolveTransclusionLog;
import org.sweble.wikitext.engine.log.UnhandledException;
import org.sweble.wikitext.engine.log.ValidatorLog;
import org.sweble.wikitext.lazy.utils.WikitextPrinter;

public class LogPrinter
extends PrinterBase {
    private boolean descend = false;

    public static String print(AstNode node, boolean descend) {
        StringWriter writer2 = new StringWriter();
        new LogPrinter(writer2, descend).go(node);
        return writer2.toString();
    }

    public static Writer print(Writer writer2, AstNode node, boolean descend) {
        new LogPrinter(writer2, descend).go(node);
        return writer2;
    }

    public void visit(CompilerLog n) throws IOException {
        this.print("Compilation");
        this.printNewline(true);
        this.print("-----------");
        this.printNewline(true);
        this.print("  Title    : ");
        this.print(n.getTitle());
        this.printNewline(true);
        this.print("  Revision : ");
        this.print(n.getRevision().toString());
        this.printNewline(false);
        if (this.descend) {
            this.print("  ");
            this.printNewline(false);
            this.incIndent("  ");
            this.iterate(n.getContent());
            this.decIndent();
            this.printNewline(false);
        }
        this.printNewline(false);
    }

    public void visit(ValidatorLog n) throws IOException {
        this.print("Validation");
        this.printNewline(true);
        this.print("----------");
        this.printNewline(true);
        this.print("  Processing time : ");
        this.print(n.getTimeNeeded().toString());
        this.print("ms");
        this.printNewline(false);
        if (this.descend) {
            this.print("  ");
            this.printNewline(false);
            this.incIndent("  ");
            this.iterate(n.getContent());
            this.decIndent();
            this.printNewline(false);
        }
        this.printNewline(false);
    }

    public void visit(PreprocessorLog n) throws IOException {
        this.print("Preprocessing");
        this.printNewline(true);
        this.print("-------------");
        this.printNewline(true);
        this.print("  For inclusion   : ");
        this.print(n.getForInclusion() ? "yes" : "no");
        this.printNewline(true);
        this.print("  Processing time : ");
        this.print(n.getTimeNeeded().toString());
        this.print("ms");
        this.printNewline(false);
        if (this.descend) {
            this.print("  ");
            this.printNewline(false);
            this.incIndent("  ");
            this.iterate(n.getContent());
            this.decIndent();
            this.printNewline(false);
        }
        this.printNewline(false);
    }

    public void visit(PpResolverLog n) throws IOException {
        this.print("Expansion");
        this.printNewline(true);
        this.print("---------");
        this.printNewline(true);
        this.print("  Processing time : ");
        this.print(n.getTimeNeeded().toString());
        this.print("ms");
        this.printNewline(false);
        if (this.descend) {
            this.print("  ");
            this.printNewline(false);
            this.incIndent("  ");
            this.iterate(n.getContent());
            this.decIndent();
            this.printNewline(false);
        }
        this.printNewline(false);
    }

    public void visit(ParserLog n) throws IOException {
        this.print("Parsing");
        this.printNewline(true);
        this.print("-------");
        this.printNewline(true);
        this.print("  Processing time : ");
        this.print(n.getTimeNeeded().toString());
        this.print("ms");
        this.printNewline(false);
        if (this.descend) {
            this.print("  ");
            this.printNewline(false);
            this.incIndent("  ");
            this.iterate(n.getContent());
            this.decIndent();
            this.printNewline(false);
        }
        this.printNewline(false);
    }

    public void visit(PostprocessorLog n) throws IOException {
        this.print("Postprocessing");
        this.printNewline(true);
        this.print("--------------");
        this.printNewline(true);
        this.print("  Processing time : ");
        this.print(n.getTimeNeeded().toString());
        this.print("ms");
        this.printNewline(false);
        if (this.descend) {
            this.print("  ");
            this.printNewline(false);
            this.incIndent("  ");
            this.iterate(n.getContent());
            this.decIndent();
            this.printNewline(false);
        }
        this.printNewline(false);
    }

    public void visit(ResolveRedirectLog n) throws IOException {
        this.print("Redirection");
        this.printNewline(true);
        this.print("-----------");
        this.printNewline(true);
        this.print("  Processing time  : ");
        this.print(n.getTimeNeeded().toString());
        this.print("ms");
        this.printNewline(true);
        this.print("  Success          : ");
        this.print(n.getSuccess() ? "yes" : "no");
        this.printNewline(true);
        this.print("  Target           : ");
        this.print(n.getTarget());
        this.printNewline(true);
        this.print("  Canonical target : ");
        this.print(n.getCanonical());
        this.printNewline(false);
        if (this.descend) {
            this.print("  ");
            this.printNewline(false);
            this.incIndent("  ");
            this.iterate(n.getContent());
            this.decIndent();
            this.printNewline(false);
        }
        this.printNewline(false);
    }

    public void visit(ResolveTransclusionLog n) throws IOException {
        this.print("Transclusion");
        this.printNewline(true);
        this.print("------------");
        this.printNewline(true);
        this.print("  Processing time  : ");
        this.print(n.getTimeNeeded().toString());
        this.print("ms");
        this.printNewline(true);
        this.print("  Success          : ");
        this.print(n.getSuccess() ? "yes" : "no");
        this.printNewline(true);
        this.print("  Target           : ");
        this.print(n.getTarget());
        this.printNewline(true);
        this.print("  Canonical target : ");
        this.print(n.getCanonical());
        this.printNewline(false);
        if (this.descend) {
            this.print("  ");
            this.printNewline(false);
            this.incIndent("  ");
            this.iterate(n.getContent());
            this.decIndent();
            this.printNewline(false);
        }
        this.printNewline(false);
    }

    public void visit(ParseException n) throws IOException {
        this.print("Parse Exception (EXCEPTION)");
        this.printNewline(true);
        this.print("---------------");
        this.printNewline(false);
        this.incIndent("  ");
        this.print(this.indentText(n.getMessage()));
        this.decIndent();
        this.printNewline(false);
    }

    public void visit(IllegalNameException n) throws IOException {
        this.print("Illegal Name Exception (EXCEPTION)");
        this.printNewline(true);
        this.print("----------------------");
        this.printNewline(false);
        this.incIndent("  ");
        this.print(this.indentText(n.getMessage()));
        this.decIndent();
        this.printNewline(false);
        this.print("  ");
        this.printNewline(true);
        this.print("  Offending name:");
        this.printNewline(false);
        this.incIndent("    ");
        this.print(this.indentText(WikitextPrinter.print(n.getName())));
        this.decIndent();
        this.printNewline(false);
    }

    public void visit(UnhandledException n) throws IOException {
        this.print("Unhandled Exception (EXCEPTION)");
        this.printNewline(true);
        this.print("-------------------");
        this.printNewline(true);
        this.print("  Dump:");
        this.printNewline(false);
        this.incIndent("    ");
        this.print(this.indentText(n.getDump()));
        this.decIndent();
        this.printNewline(false);
    }

    public LogPrinter(Writer writer2, boolean descend) {
        super(writer2);
        this.descend = descend;
    }

    public static String print(AstNode node) {
        return LogPrinter.print(node, true);
    }
}

