/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.utils;

import de.fau.cs.osr.ptk.common.PrinterBase;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.NodeList;
import de.fau.cs.osr.ptk.common.ast.Text;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.sweble.wikitext.engine.Page;
import org.sweble.wikitext.lazy.encval.IllegalCodePoint;
import org.sweble.wikitext.lazy.parser.Bold;
import org.sweble.wikitext.lazy.parser.DefinitionDefinition;
import org.sweble.wikitext.lazy.parser.DefinitionList;
import org.sweble.wikitext.lazy.parser.DefinitionTerm;
import org.sweble.wikitext.lazy.parser.Enumeration;
import org.sweble.wikitext.lazy.parser.EnumerationItem;
import org.sweble.wikitext.lazy.parser.ExternalLink;
import org.sweble.wikitext.lazy.parser.HorizontalRule;
import org.sweble.wikitext.lazy.parser.InternalLink;
import org.sweble.wikitext.lazy.parser.Italics;
import org.sweble.wikitext.lazy.parser.Itemization;
import org.sweble.wikitext.lazy.parser.ItemizationItem;
import org.sweble.wikitext.lazy.parser.MagicWord;
import org.sweble.wikitext.lazy.parser.Paragraph;
import org.sweble.wikitext.lazy.parser.Section;
import org.sweble.wikitext.lazy.parser.SemiPre;
import org.sweble.wikitext.lazy.parser.SemiPreLine;
import org.sweble.wikitext.lazy.parser.Signature;
import org.sweble.wikitext.lazy.parser.Table;
import org.sweble.wikitext.lazy.parser.TableCaption;
import org.sweble.wikitext.lazy.parser.TableCell;
import org.sweble.wikitext.lazy.parser.TableHeader;
import org.sweble.wikitext.lazy.parser.TableRow;
import org.sweble.wikitext.lazy.parser.Url;
import org.sweble.wikitext.lazy.parser.Whitespace;
import org.sweble.wikitext.lazy.parser.XmlElement;
import org.sweble.wikitext.lazy.parser.XmlElementClose;
import org.sweble.wikitext.lazy.parser.XmlElementEmpty;
import org.sweble.wikitext.lazy.parser.XmlElementOpen;
import org.sweble.wikitext.lazy.preprocessor.Redirect;
import org.sweble.wikitext.lazy.preprocessor.TagExtension;
import org.sweble.wikitext.lazy.preprocessor.Template;
import org.sweble.wikitext.lazy.preprocessor.TemplateArgument;
import org.sweble.wikitext.lazy.preprocessor.TemplateParameter;
import org.sweble.wikitext.lazy.preprocessor.XmlComment;
import org.sweble.wikitext.lazy.utils.XmlAttribute;
import org.sweble.wikitext.lazy.utils.XmlAttributeGarbage;
import org.sweble.wikitext.lazy.utils.XmlCharRef;
import org.sweble.wikitext.lazy.utils.XmlEntityRef;

public class HtmlPrinter
extends PrinterBase {
    private String classPrefix;
    private String articleTitle = "";
    private boolean renderTemplates = false;
    private boolean renderTagExtensions = false;
    private List<ExternalLink> numberedLinks = new ArrayList<ExternalLink>();
    private boolean standaloneHtml = true;
    private String cssLink;
    private File cssFile;
    private String cssResource;

    public static String print(AstNode node, String articleTitle) {
        StringWriter writer2 = new StringWriter();
        new HtmlPrinter(writer2, articleTitle).go(node);
        return writer2.toString();
    }

    public static Writer print(Writer writer2, AstNode node, String articleTitle) {
        new HtmlPrinter(writer2, articleTitle).go(node);
        return writer2;
    }

    public void visit(AstNode astNode) throws IOException {
        this.print("<span class=\"");
        this.print(this.classPrefix);
        this.print("unknown-node\">");
        this.print(astNode.getClass().getSimpleName());
        this.print("</span>");
    }

    public void visit(NodeList l) throws IOException {
        this.iterate(l);
    }

    public void visit(Page page) throws IOException {
        this.printNewline(false);
        if (this.standaloneHtml) {
            this.print("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
            this.printNewline(true);
            this.print("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"");
            this.printNewline(true);
            this.print("\t\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
            this.printNewline(true);
            this.print("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
            this.printNewline(true);
            this.print("\t<head>");
            this.printNewline(true);
            this.print("\t\t<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">");
            this.printNewline(true);
            this.print("\t\t<title>");
            this.print(HtmlPrinter.escHtml(this.articleTitle));
            this.print("</title>");
            this.printNewline(false);
            if (this.cssResource != null) {
                this.print("\t<style type=\"text/css\">");
                this.printNewline(true);
                this.print("\t\t<!--");
                this.printNewline(false);
                this.incIndent("\t\t\t");
                this.print(this.indentText(this.loadFromResource(this.cssResource)));
                this.decIndent();
                this.printNewline(false);
                this.print("\t\t-->");
                this.printNewline(true);
                this.print("\t</style>");
            } else if (this.cssFile != null) {
                this.print("\t<style type=\"text/css\">");
                this.printNewline(true);
                this.print("\t\t<!--");
                this.printNewline(false);
                this.incIndent("\t\t\t");
                this.print(this.indentText(HtmlPrinter.load(this.cssFile)));
                this.decIndent();
                this.printNewline(false);
                this.print("\t\t-->");
                this.printNewline(true);
                this.print("\t</style>");
            } else if (this.cssLink != null) {
                this.print("\t<link rel=\"stylesheet\" type=\"text/css\" href=\"");
                this.print(this.cssLink);
                this.print("\">");
            }
            this.printNewline(false);
            this.print("\t</head>");
            this.printNewline(true);
            this.print("\t<body>");
            this.printNewline(true);
        }
        this.print("<div class=\"");
        this.print(this.classPrefix);
        this.print("content\">");
        this.printNewline(true);
        this.print("\t<h1 class=\"");
        this.print(this.classPrefix);
        this.print("article-heading\">");
        this.print(HtmlPrinter.escHtml(this.articleTitle));
        this.print("</h1>");
        this.printNewline(true);
        this.print("\t<div class=\"");
        this.print(this.classPrefix);
        this.print("article-content\">");
        this.printNewline(false);
        this.incIndent("\t\t");
        this.iterate(page.getContent());
        this.decIndent();
        this.printNewline(false);
        this.print("\t</div>");
        this.printNewline(true);
        this.print("</div>");
        this.printNewline(true);
        this.print("</div>");
        this.printNewline(false);
        if (this.standaloneHtml) {
            this.print("\t</body>");
            this.printNewline(true);
            this.print("</html>");
        }
        this.printNewline(false);
        this.printNewline(false);
    }

    public void visit(Text text2) throws IOException {
        this.print(HtmlPrinter.escHtml(text2.getContent()));
    }

    public void visit(Italics n) throws IOException {
        this.print("<i>");
        this.iterate(n.getContent());
        this.print("</i>");
    }

    public void visit(Bold n) throws IOException {
        this.print("<b>");
        this.iterate(n.getContent());
        this.print("</b>");
    }

    public void visit(Whitespace n) throws IOException {
        this.iterate(n.getContent());
    }

    public void visit(Paragraph p) throws IOException {
        this.printNewline(false);
        this.renderBlockLevelElementsFirst(p);
        this.printNewline(false);
        if (!this.isParagraphEmpty(p)) {
            this.print("<p>");
            this.printNewline(false);
            this.incIndent("\t");
            this.iterate(p.getContent());
            this.decIndent();
            this.printNewline(false);
            this.print("</p>");
        }
        this.printNewline(false);
        this.printNewline(false);
    }

    public void visit(SemiPre sp2) throws IOException {
        this.printNewline(false);
        this.print("<pre>");
        this.iterate(sp2.getContent());
        this.print("</pre>");
        this.printNewline(false);
    }

    public void visit(SemiPreLine line) throws IOException {
        this.iterate(line.getContent());
        this.print("\n");
    }

    public void visit(Section s2) throws IOException {
        this.printNewline(false);
        this.print("<div class=\"");
        this.print(this.classPrefix);
        this.print("section\">");
        this.printNewline(true);
        this.print("\t<h");
        this.print(s2.getLevel());
        this.print(">");
        this.iterate(s2.getTitle());
        this.print("</h");
        this.print(s2.getLevel());
        this.print(">");
        this.printNewline(true);
        this.print("\t<div class=\"");
        this.print(this.classPrefix);
        this.print("section-body\">");
        this.printNewline(false);
        this.incIndent("\t\t");
        this.iterate(s2.getBody());
        this.decIndent();
        this.printNewline(false);
        this.print("\t</div>");
        this.printNewline(true);
        this.print("</div>");
        this.printNewline(false);
    }

    public void visit(XmlComment e) throws IOException {
    }

    public void visit(XmlElement e) throws IOException {
        this.print("<");
        this.print(e.getName());
        this.iterate(e.getXmlAttributes());
        if (e.getEmpty().booleanValue()) {
            this.print(" />");
        } else {
            this.print(">");
            this.iterate(e.getBody());
            this.print("</");
            this.print(e.getName());
            this.print(">");
        }
    }

    public void visit(XmlAttribute a) throws IOException {
        this.print(" ");
        this.print(a.getName());
        this.print("=\"");
        this.iterate(a.getValue());
        this.print("\"");
    }

    public void visit(XmlAttributeGarbage g) throws IOException {
    }

    public void visit(XmlCharRef ref) throws IOException {
        this.print("&#");
        this.print(ref.getCodePoint());
        this.print(";");
    }

    public void visit(XmlEntityRef ref) throws IOException {
        this.print("&");
        this.print(ref.getName());
        this.print(";");
    }

    public void visit(DefinitionList n) throws IOException {
        this.printNewline(false);
        this.print("<dl>");
        this.printNewline(false);
        this.incIndent("\t");
        this.iterate(n.getContent());
        this.decIndent();
        this.printNewline(false);
        this.print("</dl>");
        this.printNewline(false);
    }

    public void visit(DefinitionTerm n) throws IOException {
        this.printNewline(false);
        this.print("<dt>");
        this.iterate(n.getContent());
        this.print("</dt>");
        this.printNewline(false);
    }

    public void visit(DefinitionDefinition n) throws IOException {
        this.printNewline(false);
        this.print("<dd>");
        this.iterate(n.getContent());
        this.print("</dd>");
        this.printNewline(false);
    }

    public void visit(Enumeration n) throws IOException {
        this.printNewline(false);
        this.print("<ol>");
        this.printNewline(false);
        this.incIndent("\t");
        this.iterate(n.getContent());
        this.decIndent();
        this.printNewline(false);
        this.print("</ol>");
        this.printNewline(false);
    }

    public void visit(EnumerationItem n) throws IOException {
        this.printNewline(false);
        this.print("<li>");
        this.iterate(n.getContent());
        this.print("</li>");
        this.printNewline(false);
    }

    public void visit(Itemization n) throws IOException {
        this.printNewline(false);
        this.print("<ul>");
        this.printNewline(false);
        this.incIndent("\t");
        this.iterate(n.getContent());
        this.decIndent();
        this.printNewline(false);
        this.print("</ul>");
        this.printNewline(false);
    }

    public void visit(ItemizationItem n) throws IOException {
        this.printNewline(false);
        this.print("<li>");
        this.iterate(n.getContent());
        this.print("</li>");
        this.printNewline(false);
    }

    public void visit(ExternalLink link) throws IOException {
        this.print("<a href=\"");
        this.print(link.getTarget().getProtocol());
        this.print(":");
        this.print(link.getTarget().getPath());
        this.print("\">");
        if (!link.getTitle().isEmpty()) {
            this.iterate(link.getTitle());
        } else {
            this.printExternalLinkNumber(link);
        }
        this.print("</a>");
    }

    public void visit(Url url) throws IOException {
        this.print("<a href=\"");
        this.print(url.getProtocol());
        this.print(":");
        this.print(url.getPath());
        this.print("\">");
        this.print(url.getProtocol());
        this.print(":");
        this.print(url.getPath());
        this.print("</a>");
    }

    public void visit(InternalLink n) throws IOException {
        this.print("<a href=\"");
        this.print(this.makeLinkTarget(n));
        this.print("\">");
        this.print(n.getPrefix());
        if (n.getTitle().getContent().isEmpty()) {
            this.print(this.makeLinkTitle(n));
        } else {
            this.iterate(n.getTitle().getContent());
        }
        this.print(n.getPostfix());
        this.print("</a>");
    }

    public void visit(Table table) throws IOException {
        this.printNewline(false);
        this.print("<table");
        this.iterate(table.getXmlAttributes());
        this.print(">");
        this.printNewline(false);
        this.incIndent("\t");
        this.iterate(table.getBody());
        this.decIndent();
        this.printNewline(false);
        this.printNewline(true);
        this.print("</table>");
        this.printNewline(false);
    }

    public void visit(TableCaption caption) throws IOException {
        this.printNewline(false);
        this.print("<caption");
        this.iterate(caption.getXmlAttributes());
        this.print(">");
        this.printNewline(false);
        this.incIndent("\t");
        this.iterate(caption.getBody());
        this.decIndent();
        this.printNewline(false);
        this.print("</caption>");
        this.printNewline(false);
    }

    public void visit(TableRow row) throws IOException {
        this.printNewline(false);
        this.print("<tr");
        this.iterate(row.getXmlAttributes());
        this.print(">");
        this.printNewline(false);
        this.incIndent("\t");
        this.iterate(row.getBody());
        this.decIndent();
        this.printNewline(false);
        this.print("</tr>");
        this.printNewline(false);
    }

    public void visit(TableHeader header) throws IOException {
        this.printNewline(false);
        this.print("<th");
        this.iterate(header.getXmlAttributes());
        this.print(">");
        this.printNewline(false);
        this.incIndent("\t");
        this.iterate(header.getBody());
        this.decIndent();
        this.printNewline(false);
        this.print("</th>");
        this.printNewline(false);
    }

    public void visit(TableCell cell) throws IOException {
        this.printNewline(false);
        this.print("<td");
        this.iterate(cell.getXmlAttributes());
        this.print(">");
        this.printNewline(false);
        this.incIndent("\t");
        this.iterate(cell.getBody());
        this.decIndent();
        this.printNewline(false);
        this.print("</td>");
        this.printNewline(false);
    }

    public void visit(HorizontalRule rule) throws IOException {
        this.printNewline(false);
        this.print("<hr />");
        this.printNewline(false);
    }

    public void visit(Signature sig) throws IOException {
        this.print("<span class=\"");
        this.print(this.classPrefix);
        this.print("signature\">");
        this.print(this.makeSignature(sig));
        this.print("</span>");
    }

    public void visit(Redirect n) throws IOException {
        this.print("<span class=\"");
        this.print(this.classPrefix);
        this.print("redirect\">&#x21B3; ");
        this.print(n.getTarget());
        this.print("</span>");
    }

    public void visit(IllegalCodePoint n) throws IOException {
        this.print("<span class=\"");
        this.print(this.classPrefix);
        this.print("illegal\">");
        this.print(this.asXmlCharRefs(n.getCodePoint()));
        this.print("</span>");
    }

    public void visit(MagicWord n) throws IOException {
        this.print("<span class=\"");
        this.print(this.classPrefix);
        this.print("magic-word\">__");
        this.print(n.getWord());
        this.print("__</span>");
    }

    public void visit(TagExtension n) throws IOException {
        this.print("<span class=\"");
        this.print(this.classPrefix);
        this.print("unknown-node\">");
        if (this.renderTagExtensions) {
            if (n.getBody().isEmpty()) {
                this.print("&lt;");
                this.print(n.getName());
                this.iterate(n.getXmlAttributes());
                this.print(" />");
            } else {
                this.print("&lt;");
                this.print(n.getName());
                this.iterate(n.getXmlAttributes());
                this.print(">");
                this.print(HtmlPrinter.escHtml(n.getBody()));
                this.print("&lt;/");
                this.print(n.getName());
                this.print(">");
            }
        } else {
            if (n.getXmlAttributes().isEmpty()) {
                this.print("&lt;");
                this.print(n.getName());
            } else {
                this.print("&lt;");
                this.print(n.getName());
                this.print(" ...");
            }
            if (n.getBody().isEmpty()) {
                this.print("/>");
            } else {
                this.print(">...&lt;/");
                this.print(n.getName());
                this.print(">");
            }
        }
        this.print("</span>");
    }

    public void visit(XmlElementEmpty e) throws IOException {
        this.print("<span class=\"");
        this.print(this.classPrefix);
        this.print("unknown-node\">");
        this.print("&lt;");
        this.print(e.getName());
        this.iterate(e.getXmlAttributes());
        this.print(" />");
        this.print("</span>");
    }

    public void visit(XmlElementOpen e) throws IOException {
        this.print("<span class=\"");
        this.print(this.classPrefix);
        this.print("unknown-node\">");
        this.print("&lt;");
        this.print(e.getName());
        this.iterate(e.getXmlAttributes());
        this.print(">");
        this.print("</span>");
    }

    public void visit(XmlElementClose e) throws IOException {
        this.print("<span class=\"");
        this.print(this.classPrefix);
        this.print("unknown-node\">");
        this.print("&lt;/");
        this.print(e.getName());
        this.print(">");
        this.print("</span>");
    }

    public void visit(Template tmpl) throws IOException {
        this.print("<span class=\"");
        this.print(this.classPrefix);
        this.print("unknown-node\">");
        if (this.renderTemplates) {
            this.print("{");
            this.print("{");
            this.iterate(tmpl.getName());
            this.iterate(tmpl.getArgs());
            this.print("}}");
        } else if (tmpl.getArgs().isEmpty()) {
            this.print("{");
            this.print("{");
            this.iterate(tmpl.getName());
            this.print("}}");
        } else {
            this.print("{");
            this.print("{");
            this.iterate(tmpl.getName());
            this.print("|...}}");
        }
        this.print("</span>");
    }

    public void visit(TemplateParameter param2) throws IOException {
        this.print("<span class=\"");
        this.print(this.classPrefix);
        this.print("unknown-node\">");
        if (this.renderTemplates) {
            this.print("{");
            this.print("{");
            this.print("{");
            this.iterate(param2.getName());
            this.dispatch(param2.getDefaultValue());
            this.iterate(param2.getGarbage());
            this.print("}}}");
        } else if (param2.getDefaultValue() == null) {
            this.print("{");
            this.print("{");
            this.print("{");
            this.iterate(param2.getName());
            this.print("}}}");
        } else {
            this.print("{");
            this.print("{");
            this.print("{");
            this.iterate(param2.getName());
            this.print("|...}}}");
        }
        this.print("</span>");
    }

    public void visit(TemplateArgument arg) throws IOException {
        this.print("|");
        if (arg.getHasName()) {
            this.iterate(arg.getValue());
        } else {
            this.iterate(arg.getName());
            this.print("=");
            this.iterate(arg.getValue());
        }
    }

    public HtmlPrinter(Writer writer2, String articleTitle) {
        super(writer2);
        this.articleTitle = articleTitle;
        this.setCssResource("HtmlPrinter.css", "");
    }

    private void setClassPrefix(String classPrefix) {
        if (classPrefix != null) {
            this.classPrefix = classPrefix;
            if (!classPrefix.isEmpty()) {
                this.classPrefix = this.classPrefix + '-';
            }
        }
    }

    public boolean isStandaloneHtml() {
        return this.standaloneHtml;
    }

    public void setStandaloneHtml(boolean standaloneHtml, String classPrefix) {
        this.standaloneHtml = standaloneHtml;
        this.setClassPrefix(classPrefix);
    }

    public String getCssLink() {
        return this.cssLink;
    }

    public void setCssLink(String cssLink, String classPrefix) {
        this.cssFile = null;
        this.cssResource = null;
        this.cssLink = cssLink;
        this.setClassPrefix(classPrefix);
    }

    public File getCssFile() {
        return this.cssFile;
    }

    public void setCssFile(File cssFile, String classPrefix) {
        this.cssResource = null;
        this.cssLink = null;
        this.cssFile = cssFile;
        this.setClassPrefix(classPrefix);
    }

    public String getCssResource() {
        return this.cssResource;
    }

    public void setCssResource(String cssResource, String classPrefix) {
        this.cssFile = null;
        this.cssLink = null;
        this.cssResource = cssResource;
        this.setClassPrefix(classPrefix);
    }

    public void setRenderTemplates(boolean renderTemplates) {
        this.renderTemplates = renderTemplates;
    }

    public void setRenderTagExtensions(boolean renderTagExtensions) {
        this.renderTagExtensions = renderTagExtensions;
    }

    private String asXmlCharRefs(String codePoint) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < codePoint.length(); ++i) {
            b.append("&#");
            b.append((int)codePoint.charAt(i));
            b.append(";");
        }
        return b.toString();
    }

    private void renderBlockLevelElementsFirst(Paragraph p) {
        List l = (List)p.getAttribute("blockLevelElements");
        if (l == null) {
            return;
        }
        for (AstNode n : l) {
            this.dispatch(n);
        }
    }

    private boolean isParagraphEmpty(Paragraph p) {
        List l;
        return p.isEmpty() || (l = (List)p.getAttribute("blockLevelElements")) != null && p.size() - l.size() <= 0;
    }

    private void printExternalLinkNumber(ExternalLink link) {
        this.numberedLinks.add(link);
        this.print(this.numberedLinks.size());
    }

    private String makeLinkTitle(InternalLink n) {
        return n.getTarget();
    }

    private String makeLinkTarget(InternalLink n) {
        return n.getTarget();
    }

    private String makeSignature(Signature sig) {
        return "[SIG]";
    }
}

