/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.ext;

import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.NodeList;
import java.util.LinkedList;
import org.sweble.wikitext.engine.ExpansionFrame;
import org.sweble.wikitext.engine.ParserFunctionBase;
import org.sweble.wikitext.lazy.preprocessor.Template;
import org.sweble.wikitext.lazy.utils.StringConversionException;
import org.sweble.wikitext.lazy.utils.StringConverter;
import org.sweble.wikitext.lazy.utils.TextUtils;

public class ParserFunctionIfeq
extends ParserFunctionBase {
    private static final long serialVersionUID = 1L;

    public ParserFunctionIfeq() {
        super("#ifeq");
    }

    @Override
    public AstNode invoke(Template template, ExpansionFrame preprocessorFrame, LinkedList<AstNode> args) {
        AstNode result2;
        if (args.size() < 3) {
            return new NodeList();
        }
        AstNode arg0 = preprocessorFrame.expand(args.get(0));
        AstNode arg1 = preprocessorFrame.expand(args.get(1));
        String a = null;
        String b = null;
        try {
            a = StringConverter.convert(arg0).trim();
            b = StringConverter.convert(arg1).trim();
        }
        catch (StringConversionException e1) {
            // empty catch block
        }
        boolean eval = false;
        if (a != null && b != null) {
            boolean numbers = false;
            double ia = -1.0;
            double ib = 1.0;
            try {
                ia = Double.parseDouble(a);
                ib = Double.parseDouble(b);
                numbers = true;
            }
            catch (NumberFormatException e) {
                numbers = false;
            }
            eval = numbers ? ia == ib : a.equals(b);
        }
        if (eval) {
            result2 = args.get(2);
        } else {
            result2 = null;
            if (args.size() >= 4) {
                result2 = args.get(3);
            }
        }
        if (result2 != null) {
            result2 = preprocessorFrame.expand(result2);
        }
        if (result2 == null) {
            result2 = new NodeList();
        }
        if (result2.isNodeType(2)) {
            return TextUtils.trim((NodeList)result2);
        }
        return result2;
    }
}

