/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.ext;

import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.NodeList;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.sweble.wikitext.engine.ExpansionFrame;
import org.sweble.wikitext.engine.ParserFunctionBase;
import org.sweble.wikitext.lazy.preprocessor.Template;
import org.sweble.wikitext.lazy.utils.TextUtils;
import org.sweble.wikitext.lazy.utils.WikitextPrinter;

public class ParserFunctionIfError
extends ParserFunctionBase {
    private static final long serialVersionUID = 1L;
    private static final Pattern classErrorPattern = Pattern.compile("<[^<>\\s]*?\\sclass\\s*=\\s*\"error\"[^<>]*>");

    public ParserFunctionIfError() {
        super("#iferror");
    }

    @Override
    public AstNode invoke(Template template, ExpansionFrame preprocessorFrame, LinkedList<AstNode> args) {
        AstNode result2;
        if (args.size() < 1) {
            return new NodeList();
        }
        AstNode test = preprocessorFrame.expand(args.get(0));
        boolean wasError = this.searchForError(test);
        if (wasError) {
            result2 = null;
            if (args.size() >= 2) {
                result2 = args.get(1);
            }
        } else {
            result2 = test;
            if (args.size() >= 3) {
                result2 = args.get(2);
            }
        }
        if (result2 != test && result2 != null) {
            result2 = preprocessorFrame.expand(result2);
        }
        if (result2 == null) {
            result2 = new NodeList();
        }
        if (result2.isNodeType(2)) {
            return TextUtils.trim((NodeList)result2);
        }
        return result2;
    }

    private boolean searchForError(AstNode test) {
        String s2 = WikitextPrinter.print(test);
        return classErrorPattern.matcher(s2).find();
    }
}

