/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine;

import de.fau.cs.osr.ptk.common.AstVisitor;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.NodeList;
import de.fau.cs.osr.ptk.common.ast.Text;
import de.fau.cs.osr.utils.Tuple2;
import java.util.LinkedList;
import java.util.List;
import org.sweble.wikitext.engine.ExpansionFrame;
import org.sweble.wikitext.lazy.preprocessor.Redirect;
import org.sweble.wikitext.lazy.preprocessor.TagExtension;
import org.sweble.wikitext.lazy.preprocessor.Template;
import org.sweble.wikitext.lazy.preprocessor.TemplateArgument;
import org.sweble.wikitext.lazy.preprocessor.TemplateParameter;
import org.sweble.wikitext.lazy.utils.StringConversionException;
import org.sweble.wikitext.lazy.utils.StringConverter;
import org.sweble.wikitext.lazy.utils.StringConverterPartial;

public final class ExpansionVisitor
extends AstVisitor {
    private final ExpansionFrame preprocessorFrame;

    public ExpansionVisitor(ExpansionFrame preprocessorFrame) {
        this.preprocessorFrame = preprocessorFrame;
    }

    public AstNode visit(AstNode n) {
        this.mapInPlace(n);
        return n;
    }

    public AstNode visit(Redirect n) {
        String target = n.getTarget();
        AstNode result2 = this.preprocessorFrame.resolveRedirect(n, target);
        if (result2 == null) {
            result2 = n;
        }
        return result2;
    }

    public AstNode visit(Template n) {
        AstNode result2 = null;
        Tuple2<String, NodeList> converted = StringConverterPartial.convert(n.getName());
        String title = (String)converted._1;
        NodeList tail = (NodeList)converted._2;
        List<Object> args = this.map(n.getArgs());
        int i = title.indexOf(58);
        if (i != -1) {
            String pfn = title.substring(0, i).trim();
            NodeList arg0 = new NodeList((AstNode)new Text(title.substring(i + 1)), tail);
            LinkedList<Object> pfnArgs = new LinkedList<Object>(args);
            pfnArgs.addFirst(new TemplateArgument(arg0, false));
            result2 = this.preprocessorFrame.resolveParserFunction(n, pfn, pfnArgs);
        }
        if (result2 == null) {
            if (tail == null) {
                result2 = this.preprocessorFrame.resolveTransclusionOrMagicWord(n, title, args);
            } else {
                this.preprocessorFrame.illegalTemplateName(new StringConversionException(tail), n.getName());
            }
        }
        if (result2 == null) {
            result2 = n;
        }
        return result2;
    }

    public AstNode visit(TemplateParameter n) {
        this.dispatch(n.getName());
        String name2 = null;
        try {
            name2 = StringConverter.convert(n.getName());
        }
        catch (StringConversionException e) {
            this.preprocessorFrame.illegalParameterName(e, n.getName());
        }
        AstNode value = null;
        if (name2 != null) {
            name2 = name2.trim();
            value = this.preprocessorFrame.resolveParameter(n, name2);
        }
        if (value == null && n.getDefaultValue() != null) {
            TemplateArgument arg = n.getDefaultValue();
            this.dispatch(arg.getValue());
            if (arg.getHasName()) {
                this.dispatch(arg.getName());
                value = new NodeList();
                value.add(arg.getName());
                value.add(new Text("="));
                value.add(arg.getValue());
            } else {
                value = arg.getValue();
            }
        }
        if (value == null) {
            value = n;
        }
        return value;
    }

    public AstNode visit(TagExtension n) {
        return this.preprocessorFrame.resolveTagExtension(n, n.getName(), n.getXmlAttributes(), n.getBody());
    }
}

