/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;

public class ContextExposingHttpServletRequest
extends HttpServletRequestWrapper {
    private final WebApplicationContext webApplicationContext;
    private final Set exposedContextBeanNames;
    private Set explicitAttributes;

    public ContextExposingHttpServletRequest(HttpServletRequest originalRequest, WebApplicationContext context) {
        this(originalRequest, context, null);
    }

    public ContextExposingHttpServletRequest(HttpServletRequest originalRequest, WebApplicationContext context, Set exposedContextBeanNames) {
        super(originalRequest);
        Assert.notNull(context, "WebApplicationContext must not be null");
        this.webApplicationContext = context;
        this.exposedContextBeanNames = exposedContextBeanNames;
    }

    public final WebApplicationContext getWebApplicationContext() {
        return this.webApplicationContext;
    }

    public Object getAttribute(String name2) {
        if (!(this.explicitAttributes != null && this.explicitAttributes.contains(name2) || this.exposedContextBeanNames != null && !this.exposedContextBeanNames.contains(name2) || !this.webApplicationContext.containsBean(name2))) {
            return this.webApplicationContext.getBean(name2);
        }
        return super.getAttribute(name2);
    }

    public void setAttribute(String name2, Object value) {
        super.setAttribute(name2, value);
        if (this.explicitAttributes == null) {
            this.explicitAttributes = new HashSet(8);
        }
        this.explicitAttributes.add(name2);
    }
}

