/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import java.beans.PropertyEditor;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.validation.AbstractBindingResult;

public abstract class AbstractPropertyBindingResult
extends AbstractBindingResult {
    protected AbstractPropertyBindingResult(String objectName) {
        super(objectName);
    }

    public PropertyEditorRegistry getPropertyEditorRegistry() {
        return this.getPropertyAccessor();
    }

    protected String canonicalFieldName(String field2) {
        return PropertyAccessorUtils.canonicalPropertyName(field2);
    }

    public Class getFieldType(String field2) {
        return this.getPropertyAccessor().getPropertyType(this.fixedField(field2));
    }

    protected Object getActualFieldValue(String field2) {
        return this.getPropertyAccessor().getPropertyValue(field2);
    }

    protected Object formatFieldValue(String field2, Object value) {
        PropertyEditor customEditor = this.getCustomEditor(field2);
        if (customEditor != null) {
            customEditor.setValue(value);
            String textValue = customEditor.getAsText();
            if (textValue != null) {
                return textValue;
            }
        }
        return value;
    }

    protected PropertyEditor getCustomEditor(String field2) {
        String fixedField = this.fixedField(field2);
        Class targetType = this.getPropertyAccessor().getPropertyType(fixedField);
        PropertyEditor editor = this.getPropertyAccessor().findCustomEditor(targetType, fixedField);
        if (editor == null) {
            editor = BeanUtils.findEditorByConvention(targetType);
        }
        return editor;
    }

    public abstract ConfigurablePropertyAccessor getPropertyAccessor();
}

