/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.comparator;

import java.io.Serializable;
import java.util.Comparator;

public class InvertibleComparator
implements Comparator,
Serializable {
    private final Comparator comparator;
    private boolean ascending = true;

    public InvertibleComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public InvertibleComparator(Comparator comparator, boolean ascending) {
        this.comparator = comparator;
        this.setAscending(ascending);
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void invertOrder() {
        this.ascending = !this.ascending;
    }

    public int compare(Object o1, Object o2) {
        int result2 = this.comparator.compare(o1, o2);
        if (result2 != 0) {
            if (!this.ascending) {
                result2 = Integer.MIN_VALUE == result2 ? Integer.MAX_VALUE : (result2 *= -1);
            }
            return result2;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InvertibleComparator)) {
            return false;
        }
        InvertibleComparator other = (InvertibleComparator)obj;
        return ((Object)this.comparator).equals(other.comparator) && this.ascending == other.ascending;
    }

    public int hashCode() {
        return this.comparator.hashCode();
    }

    public String toString() {
        return "InvertibleComparator: [" + this.comparator + "]; ascending=" + this.ascending;
    }
}

