/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.beans.PropertyEditorSupport;
import org.springframework.transaction.interceptor.NoRollbackRuleAttribute;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.util.StringUtils;

public class TransactionAttributeEditor
extends PropertyEditorSupport {
    public void setAsText(String text2) throws IllegalArgumentException {
        if (StringUtils.hasLength(text2)) {
            String[] tokens = StringUtils.commaDelimitedListToStringArray(text2);
            RuleBasedTransactionAttribute attr2 = new RuleBasedTransactionAttribute();
            for (int i = 0; i < tokens.length; ++i) {
                String token = StringUtils.trimWhitespace(tokens[i].trim());
                if (StringUtils.containsWhitespace(token)) {
                    throw new IllegalArgumentException("Transaction attribute token contains illegal whitespace: [" + token + "]");
                }
                if (token.startsWith("PROPAGATION_")) {
                    attr2.setPropagationBehaviorName(token);
                    continue;
                }
                if (token.startsWith("ISOLATION_")) {
                    attr2.setIsolationLevelName(token);
                    continue;
                }
                if (token.startsWith("timeout_")) {
                    String value = token.substring("timeout_".length());
                    attr2.setTimeout(Integer.parseInt(value));
                    continue;
                }
                if (token.equals("readOnly")) {
                    attr2.setReadOnly(true);
                    continue;
                }
                if (token.startsWith("+")) {
                    attr2.getRollbackRules().add(new NoRollbackRuleAttribute(token.substring(1)));
                    continue;
                }
                if (token.startsWith("-")) {
                    attr2.getRollbackRules().add(new RollbackRuleAttribute(token.substring(1)));
                    continue;
                }
                throw new IllegalArgumentException("Invalid transaction attribute token: [" + token + "]");
            }
            this.setValue(attr2);
        } else {
            this.setValue(null);
        }
    }
}

