/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeEditor;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PatternMatchUtils;

public class NameMatchTransactionAttributeSource
implements TransactionAttributeSource,
Serializable {
    protected static final Log logger = LogFactory.getLog(NameMatchTransactionAttributeSource.class);
    private Map nameMap = new HashMap();

    public void setNameMap(Map nameMap) {
        Iterator it = nameMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String name2 = (String)entry.getKey();
            TransactionAttribute attr2 = null;
            if (entry.getValue() instanceof TransactionAttribute) {
                attr2 = (TransactionAttribute)entry.getValue();
            } else {
                TransactionAttributeEditor editor = new TransactionAttributeEditor();
                editor.setAsText(entry.getValue().toString());
                attr2 = (TransactionAttribute)editor.getValue();
            }
            this.addTransactionalMethod(name2, attr2);
        }
    }

    public void setProperties(Properties transactionAttributes) {
        TransactionAttributeEditor tae = new TransactionAttributeEditor();
        Iterator<Object> it = transactionAttributes.keySet().iterator();
        while (it.hasNext()) {
            String methodName = (String)it.next();
            String value = transactionAttributes.getProperty(methodName);
            tae.setAsText(value);
            TransactionAttribute attr2 = (TransactionAttribute)tae.getValue();
            this.addTransactionalMethod(methodName, attr2);
        }
    }

    public void addTransactionalMethod(String methodName, TransactionAttribute attr2) {
        if (logger.isDebugEnabled()) {
            logger.debug("Adding transactional method [" + methodName + "] with attribute [" + attr2 + "]");
        }
        this.nameMap.put(methodName, attr2);
    }

    public TransactionAttribute getTransactionAttribute(Method method, Class targetClass) {
        String methodName = method.getName();
        TransactionAttribute attr2 = (TransactionAttribute)this.nameMap.get(methodName);
        if (attr2 == null) {
            String bestNameMatch = null;
            Iterator it = this.nameMap.keySet().iterator();
            while (it.hasNext()) {
                String mappedName = (String)it.next();
                if (!this.isMatch(methodName, mappedName) || bestNameMatch != null && bestNameMatch.length() > mappedName.length()) continue;
                attr2 = (TransactionAttribute)this.nameMap.get(mappedName);
                bestNameMatch = mappedName;
            }
        }
        return attr2;
    }

    protected boolean isMatch(String methodName, String mappedName) {
        return PatternMatchUtils.simpleMatch(mappedName, methodName);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NameMatchTransactionAttributeSource)) {
            return false;
        }
        NameMatchTransactionAttributeSource otherTas = (NameMatchTransactionAttributeSource)other;
        return ObjectUtils.nullSafeEquals(this.nameMap, otherTas.nameMap);
    }

    public int hashCode() {
        return NameMatchTransactionAttributeSource.class.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.nameMap;
    }
}

