/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.caucho;

import com.caucho.hessian.io.SerializerFactory;
import com.caucho.hessian.server.HessianSkeleton;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import org.apache.commons.logging.Log;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.remoting.caucho.Hessian1SkeletonInvoker;
import org.springframework.remoting.caucho.Hessian2SkeletonInvoker;
import org.springframework.remoting.caucho.HessianServiceExporter;
import org.springframework.remoting.caucho.HessianSkeletonInvoker;
import org.springframework.remoting.support.RemoteExporter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class HessianExporter
extends RemoteExporter
implements InitializingBean {
    private static final boolean hessian2Available = ClassUtils.isPresent("com.caucho.hessian.io.Hessian2Input", HessianServiceExporter.class.getClassLoader());
    private SerializerFactory serializerFactory = new SerializerFactory();
    private Log debugLogger;
    private HessianSkeletonInvoker skeletonInvoker;

    public void setSerializerFactory(SerializerFactory serializerFactory) {
        this.serializerFactory = serializerFactory != null ? serializerFactory : new SerializerFactory();
    }

    public void setSendCollectionType(boolean sendCollectionType) {
        this.serializerFactory.setSendCollectionType(sendCollectionType);
    }

    public void setDebug(boolean debug) {
        this.debugLogger = debug ? this.logger : null;
    }

    public void afterPropertiesSet() {
        this.prepare();
    }

    public void prepare() {
        HessianSkeleton skeleton = null;
        try {
            try {
                Constructor ctor = HessianSkeleton.class.getConstructor(Object.class, Class.class);
                this.checkService();
                this.checkServiceInterface();
                skeleton = (HessianSkeleton)ctor.newInstance(this.getProxyForService(), this.getServiceInterface());
            }
            catch (NoSuchMethodException ex) {
                Constructor ctor = HessianSkeleton.class.getConstructor(Object.class);
                skeleton = (HessianSkeleton)ctor.newInstance(this.getProxyForService());
            }
        }
        catch (Throwable ex) {
            throw new BeanInitializationException("Hessian skeleton initialization failed", ex);
        }
        this.skeletonInvoker = hessian2Available ? new Hessian2SkeletonInvoker(skeleton, this.serializerFactory, this.debugLogger) : new Hessian1SkeletonInvoker(skeleton, this.serializerFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(InputStream inputStream2, OutputStream outputStream2) throws Throwable {
        Assert.notNull(this.skeletonInvoker, "Hessian exporter has not been initialized");
        ClassLoader originalClassLoader = this.overrideThreadContextClassLoader();
        try {
            this.skeletonInvoker.invoke(inputStream2, outputStream2);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.resetThreadContextClassLoader(originalClassLoader);
            throw throwable;
        }
        this.resetThreadContextClassLoader(originalClassLoader);
    }
}

