/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mail.javamail;

import java.beans.PropertyEditorSupport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.springframework.util.StringUtils;

public class InternetAddressEditor
extends PropertyEditorSupport {
    public void setAsText(String text2) throws IllegalArgumentException {
        if (StringUtils.hasText(text2)) {
            try {
                this.setValue(new InternetAddress(text2));
            }
            catch (AddressException ex) {
                throw new IllegalArgumentException("Could not parse mail address: " + ex.getMessage());
            }
        } else {
            this.setValue(null);
        }
    }

    public String getAsText() {
        InternetAddress value = (InternetAddress)this.getValue();
        return value != null ? value.toUnicodeString() : "";
    }
}

