/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener.serversession;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.ServerSession;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.springframework.jms.listener.serversession.AbstractPoolingServerSessionFactory;
import org.springframework.jms.listener.serversession.ListenerSessionManager;

public class CommonsPoolServerSessionFactory
extends AbstractPoolingServerSessionFactory {
    private int maxIdle = 8;
    private int minIdle = 0;
    private long maxWait = -1L;
    private long timeBetweenEvictionRunsMillis = -1L;
    private long minEvictableIdleTimeMillis = 1800000L;
    private final Map serverSessionPools = Collections.synchronizedMap(new HashMap(1));

    public CommonsPoolServerSessionFactory() {
        this.setMaxSize(8);
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public void setMaxWait(long maxWait) {
        this.maxWait = maxWait;
    }

    public long getMaxWait() {
        return this.maxWait;
    }

    public void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerSession getServerSession(ListenerSessionManager sessionManager) throws JMSException {
        ObjectPool pool = null;
        Map map2 = this.serverSessionPools;
        synchronized (map2) {
            pool = (ObjectPool)this.serverSessionPools.get(sessionManager);
            if (pool == null) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Creating Commons ServerSession pool for: " + sessionManager);
                }
                pool = this.createObjectPool(sessionManager);
                this.serverSessionPools.put(sessionManager, pool);
            }
        }
        try {
            return (ServerSession)pool.borrowObject();
        }
        catch (Exception ex) {
            JMSException jmsEx = new JMSException("Failed to borrow ServerSession from pool");
            jmsEx.setLinkedException(ex);
            throw jmsEx;
        }
    }

    protected ObjectPool createObjectPool(ListenerSessionManager sessionManager) {
        GenericObjectPool pool = new GenericObjectPool(this.createPoolableObjectFactory(sessionManager));
        pool.setMaxActive(this.getMaxSize());
        pool.setMaxIdle(this.getMaxIdle());
        pool.setMinIdle(this.getMinIdle());
        pool.setMaxWait(this.getMaxWait());
        pool.setTimeBetweenEvictionRunsMillis(this.getTimeBetweenEvictionRunsMillis());
        pool.setMinEvictableIdleTimeMillis(this.getMinEvictableIdleTimeMillis());
        return pool;
    }

    protected PoolableObjectFactory createPoolableObjectFactory(final ListenerSessionManager sessionManager) {
        return new PoolableObjectFactory(){

            public Object makeObject() throws JMSException {
                return CommonsPoolServerSessionFactory.this.createServerSession(sessionManager);
            }

            public void destroyObject(Object obj) {
                CommonsPoolServerSessionFactory.this.destroyServerSession((ServerSession)obj);
            }

            public boolean validateObject(Object obj) {
                return true;
            }

            public void activateObject(Object obj) {
            }

            public void passivateObject(Object obj) {
            }
        };
    }

    protected void serverSessionFinished(ServerSession serverSession, ListenerSessionManager sessionManager) {
        ObjectPool pool = (ObjectPool)this.serverSessionPools.get(sessionManager);
        if (pool == null) {
            throw new IllegalStateException("No pool found for session manager [" + sessionManager + "]");
        }
        try {
            pool.returnObject((Object)serverSession);
        }
        catch (Exception ex) {
            this.logger.error("Failed to return ServerSession to pool", ex);
        }
    }

    public void close(ListenerSessionManager sessionManager) {
        ObjectPool pool = (ObjectPool)this.serverSessionPools.remove(sessionManager);
        if (pool != null) {
            try {
                pool.close();
            }
            catch (Exception ex) {
                this.logger.error("Failed to close ServerSession pool", ex);
            }
        }
    }
}

