/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.rowset;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.springframework.jdbc.InvalidResultSetAccessException;
import org.springframework.jdbc.support.rowset.ResultSetWrappingSqlRowSetMetaData;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;

public class ResultSetWrappingSqlRowSet
implements SqlRowSet {
    private static final long serialVersionUID = -4688694393146734764L;
    private final ResultSet resultSet;
    private final SqlRowSetMetaData rowSetMetaData;

    public ResultSetWrappingSqlRowSet(ResultSet resultSet) throws InvalidResultSetAccessException {
        this.resultSet = resultSet;
        try {
            this.rowSetMetaData = new ResultSetWrappingSqlRowSetMetaData(resultSet.getMetaData());
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public final ResultSet getResultSet() {
        return this.resultSet;
    }

    public final SqlRowSetMetaData getMetaData() {
        return this.rowSetMetaData;
    }

    public int findColumn(String columnName) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.findColumn(columnName);
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public BigDecimal getBigDecimal(int columnIndex) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getBigDecimal(columnIndex);
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public BigDecimal getBigDecimal(String columnName) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getBigDecimal(columnName);
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public boolean getBoolean(int columnIndex) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getBoolean(columnIndex);
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public boolean getBoolean(String columnName) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getBoolean(columnName);
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public byte getByte(int columnIndex) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getByte(columnIndex);
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public byte getByte(String columnName) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getByte(columnName);
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public Date getDate(int columnIndex, Calendar cal) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getDate(columnIndex, cal);
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public Date getDate(int columnIndex) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getDate(columnIndex);
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public Date getDate(String columnName, Calendar cal) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getDate(columnName, cal);
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public Date getDate(String columnName) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getDate(columnName);
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public double getDouble(int columnIndex) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getDouble(columnIndex);
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public double getDouble(String columnName) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getDouble(columnName);
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public float getFloat(int columnIndex) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getFloat(columnIndex);
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public float getFloat(String columnName) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getFloat(columnName);
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public int getInt(int columnIndex) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getInt(columnIndex);
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public int getInt(String columnName) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getInt(columnName);
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public long getLong(int columnIndex) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getLong(columnIndex);
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public long getLong(String columnName) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getLong(columnName);
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public Object getObject(int i, Map map2) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getObject(i, map2);
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public Object getObject(int columnIndex) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getObject(columnIndex);
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public Object getObject(String columnName, Map map2) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getObject(columnName, map2);
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public Object getObject(String columnName) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getObject(columnName);
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public short getShort(int columnIndex) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getShort(columnIndex);
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public short getShort(String columnName) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getShort(columnName);
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public String getString(int columnIndex) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getString(columnIndex);
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public String getString(String columnName) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getString(columnName);
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public Time getTime(int columnIndex, Calendar cal) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getTime(columnIndex, cal);
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public Time getTime(int columnIndex) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getTime(columnIndex);
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public Time getTime(String columnName, Calendar cal) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getTime(columnName, cal);
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public Time getTime(String columnName) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getTime(columnName);
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getTimestamp(columnIndex, cal);
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public Timestamp getTimestamp(int columnIndex) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getTimestamp(columnIndex);
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getTimestamp(columnName, cal);
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public Timestamp getTimestamp(String columnName) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getTimestamp(columnName);
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public boolean absolute(int row) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.absolute(row);
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public void afterLast() throws InvalidResultSetAccessException {
        try {
            this.resultSet.afterLast();
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public void beforeFirst() throws InvalidResultSetAccessException {
        try {
            this.resultSet.beforeFirst();
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public boolean first() throws InvalidResultSetAccessException {
        try {
            return this.resultSet.first();
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public int getRow() throws InvalidResultSetAccessException {
        try {
            return this.resultSet.getRow();
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public boolean isAfterLast() throws InvalidResultSetAccessException {
        try {
            return this.resultSet.isAfterLast();
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public boolean isBeforeFirst() throws InvalidResultSetAccessException {
        try {
            return this.resultSet.isBeforeFirst();
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public boolean isFirst() throws InvalidResultSetAccessException {
        try {
            return this.resultSet.isFirst();
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public boolean isLast() throws InvalidResultSetAccessException {
        try {
            return this.resultSet.isLast();
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public boolean last() throws InvalidResultSetAccessException {
        try {
            return this.resultSet.last();
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public boolean next() throws InvalidResultSetAccessException {
        try {
            return this.resultSet.next();
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public boolean previous() throws InvalidResultSetAccessException {
        try {
            return this.resultSet.previous();
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public boolean relative(int rows) throws InvalidResultSetAccessException {
        try {
            return this.resultSet.relative(rows);
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }

    public boolean wasNull() throws InvalidResultSetAccessException {
        try {
            return this.resultSet.wasNull();
        }
        catch (SQLException se) {
            throw new InvalidResultSetAccessException(se);
        }
    }
}

