/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.object;

import java.util.Map;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ParameterMapper;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.object.SqlCall;

public abstract class StoredProcedure
extends SqlCall {
    protected StoredProcedure() {
    }

    protected StoredProcedure(DataSource ds, String name2) {
        this.setDataSource(ds);
        this.setSql(name2);
    }

    protected StoredProcedure(JdbcTemplate jdbcTemplate, String name2) {
        this.setJdbcTemplate(jdbcTemplate);
        this.setSql(name2);
    }

    protected boolean allowsUnusedParameters() {
        return true;
    }

    public void declareParameter(SqlParameter param2) throws InvalidDataAccessApiUsageException {
        if (param2.getName() == null) {
            throw new InvalidDataAccessApiUsageException("Parameters to stored procedures must have names as well as types");
        }
        super.declareParameter(param2);
    }

    public Map execute(Map inParams) throws DataAccessException {
        this.validateParameters(inParams.values().toArray());
        return this.getJdbcTemplate().call(this.newCallableStatementCreator(inParams), this.getDeclaredParameters());
    }

    public Map execute(ParameterMapper inParamMapper) throws DataAccessException {
        this.checkCompiled();
        return this.getJdbcTemplate().call(this.newCallableStatementCreator(inParamMapper), this.getDeclaredParameters());
    }
}

