/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.namedparam;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementCreatorFactory;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.core.SqlRowSetResultSetExtractor;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterUtils;
import org.springframework.jdbc.core.namedparam.ParsedSql;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.util.Assert;

public class NamedParameterJdbcTemplate
implements NamedParameterJdbcOperations {
    private final JdbcOperations classicJdbcTemplate;
    private final Map parsedSqlCache = new HashMap();

    public NamedParameterJdbcTemplate(DataSource dataSource) {
        Assert.notNull(dataSource, "The [dataSource] argument cannot be null.");
        this.classicJdbcTemplate = new JdbcTemplate(dataSource);
    }

    public NamedParameterJdbcTemplate(JdbcOperations classicJdbcTemplate) {
        Assert.notNull(classicJdbcTemplate, "JdbcTemplate must not be null");
        this.classicJdbcTemplate = classicJdbcTemplate;
    }

    public JdbcOperations getJdbcOperations() {
        return this.classicJdbcTemplate;
    }

    public Object execute(String sql, SqlParameterSource paramSource, PreparedStatementCallback action) throws DataAccessException {
        return this.getJdbcOperations().execute(this.getPreparedStatementCreator(sql, paramSource), action);
    }

    public Object execute(String sql, Map paramMap, PreparedStatementCallback action) throws DataAccessException {
        return this.execute(sql, new MapSqlParameterSource(paramMap), action);
    }

    public Object query(String sql, SqlParameterSource paramSource, ResultSetExtractor rse) throws DataAccessException {
        return this.getJdbcOperations().query(this.getPreparedStatementCreator(sql, paramSource), rse);
    }

    public Object query(String sql, Map paramMap, ResultSetExtractor rse) throws DataAccessException {
        return this.query(sql, (SqlParameterSource)new MapSqlParameterSource(paramMap), rse);
    }

    public void query(String sql, SqlParameterSource paramSource, RowCallbackHandler rch) throws DataAccessException {
        this.getJdbcOperations().query(this.getPreparedStatementCreator(sql, paramSource), rch);
    }

    public void query(String sql, Map paramMap, RowCallbackHandler rch) throws DataAccessException {
        this.query(sql, (SqlParameterSource)new MapSqlParameterSource(paramMap), rch);
    }

    public List query(String sql, SqlParameterSource paramSource, RowMapper rowMapper) throws DataAccessException {
        return this.getJdbcOperations().query(this.getPreparedStatementCreator(sql, paramSource), rowMapper);
    }

    public List query(String sql, Map paramMap, RowMapper rowMapper) throws DataAccessException {
        return this.query(sql, (SqlParameterSource)new MapSqlParameterSource(paramMap), rowMapper);
    }

    public Object queryForObject(String sql, SqlParameterSource paramSource, RowMapper rowMapper) throws DataAccessException {
        List results = this.getJdbcOperations().query(this.getPreparedStatementCreator(sql, paramSource), rowMapper);
        return DataAccessUtils.requiredSingleResult(results);
    }

    public Object queryForObject(String sql, Map paramMap, RowMapper rowMapper) throws DataAccessException {
        return this.queryForObject(sql, (SqlParameterSource)new MapSqlParameterSource(paramMap), rowMapper);
    }

    public Object queryForObject(String sql, SqlParameterSource paramSource, Class requiredType) throws DataAccessException {
        return this.queryForObject(sql, paramSource, (RowMapper)new SingleColumnRowMapper(requiredType));
    }

    public Object queryForObject(String sql, Map paramMap, Class requiredType) throws DataAccessException {
        return this.queryForObject(sql, paramMap, (RowMapper)new SingleColumnRowMapper(requiredType));
    }

    public Map queryForMap(String sql, SqlParameterSource paramSource) throws DataAccessException {
        return (Map)this.queryForObject(sql, paramSource, (RowMapper)new ColumnMapRowMapper());
    }

    public Map queryForMap(String sql, Map paramMap) throws DataAccessException {
        return (Map)this.queryForObject(sql, paramMap, (RowMapper)new ColumnMapRowMapper());
    }

    public long queryForLong(String sql, SqlParameterSource paramSource) throws DataAccessException {
        Number number = (Number)this.queryForObject(sql, paramSource, Number.class);
        return number != null ? number.longValue() : 0L;
    }

    public long queryForLong(String sql, Map paramMap) throws DataAccessException {
        return this.queryForLong(sql, new MapSqlParameterSource(paramMap));
    }

    public int queryForInt(String sql, SqlParameterSource paramSource) throws DataAccessException {
        Number number = (Number)this.queryForObject(sql, paramSource, Number.class);
        return number != null ? number.intValue() : 0;
    }

    public int queryForInt(String sql, Map paramMap) throws DataAccessException {
        return this.queryForInt(sql, new MapSqlParameterSource(paramMap));
    }

    public List queryForList(String sql, SqlParameterSource paramSource, Class elementType) throws DataAccessException {
        return this.query(sql, paramSource, (RowMapper)new SingleColumnRowMapper(elementType));
    }

    public List queryForList(String sql, Map paramMap, Class elementType) throws DataAccessException {
        return this.queryForList(sql, new MapSqlParameterSource(paramMap), elementType);
    }

    public List queryForList(String sql, SqlParameterSource paramSource) throws DataAccessException {
        return this.query(sql, paramSource, (RowMapper)new ColumnMapRowMapper());
    }

    public List queryForList(String sql, Map paramMap) throws DataAccessException {
        return this.queryForList(sql, new MapSqlParameterSource(paramMap));
    }

    public SqlRowSet queryForRowSet(String sql, SqlParameterSource paramSource) throws DataAccessException {
        return (SqlRowSet)this.getJdbcOperations().query(this.getPreparedStatementCreator(sql, paramSource), (ResultSetExtractor)new SqlRowSetResultSetExtractor());
    }

    public SqlRowSet queryForRowSet(String sql, Map paramMap) throws DataAccessException {
        return this.queryForRowSet(sql, new MapSqlParameterSource(paramMap));
    }

    public int update(String sql, SqlParameterSource paramSource) throws DataAccessException {
        return this.getJdbcOperations().update(this.getPreparedStatementCreator(sql, paramSource));
    }

    public int update(String sql, Map paramMap) throws DataAccessException {
        return this.update(sql, new MapSqlParameterSource(paramMap));
    }

    public int update(String sql, SqlParameterSource paramSource, KeyHolder generatedKeyHolder) throws DataAccessException {
        return this.update(sql, paramSource, generatedKeyHolder, null);
    }

    public int update(String sql, SqlParameterSource paramSource, KeyHolder generatedKeyHolder, String[] keyColumnNames) throws DataAccessException {
        ParsedSql parsedSql = this.getParsedSql(sql);
        String sqlToUse = NamedParameterUtils.substituteNamedParameters(parsedSql, paramSource);
        Object[] params = NamedParameterUtils.buildValueArray(parsedSql, paramSource, null);
        int[] paramTypes = NamedParameterUtils.buildSqlTypeArray(parsedSql, paramSource);
        PreparedStatementCreatorFactory pscf = new PreparedStatementCreatorFactory(sqlToUse, paramTypes);
        if (keyColumnNames != null) {
            pscf.setGeneratedKeysColumnNames(keyColumnNames);
        } else {
            pscf.setReturnGeneratedKeys(true);
        }
        return this.getJdbcOperations().update(pscf.newPreparedStatementCreator(params), generatedKeyHolder);
    }

    protected PreparedStatementCreator getPreparedStatementCreator(String sql, SqlParameterSource paramSource) {
        ParsedSql parsedSql = this.getParsedSql(sql);
        String sqlToUse = NamedParameterUtils.substituteNamedParameters(parsedSql, paramSource);
        Object[] params = NamedParameterUtils.buildValueArray(parsedSql, paramSource, null);
        int[] paramTypes = NamedParameterUtils.buildSqlTypeArray(parsedSql, paramSource);
        PreparedStatementCreatorFactory pscf = new PreparedStatementCreatorFactory(sqlToUse, paramTypes);
        return pscf.newPreparedStatementCreator(params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ParsedSql getParsedSql(String sql) {
        Map map2 = this.parsedSqlCache;
        synchronized (map2) {
            ParsedSql parsedSql = (ParsedSql)this.parsedSqlCache.get(sql);
            if (parsedSql == null) {
                parsedSql = NamedParameterUtils.parseSqlStatement(sql);
                this.parsedSqlCache.put(sql, parsedSql);
            }
            return parsedSql;
        }
    }
}

