/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.util.LinkedList;
import java.util.List;
import org.springframework.util.Assert;

public class SqlParameter {
    private String name;
    private final int sqlType;
    private String typeName;
    private Integer scale;

    public SqlParameter(int sqlType) {
        this.sqlType = sqlType;
    }

    public SqlParameter(int sqlType, String typeName) {
        this.sqlType = sqlType;
        this.typeName = typeName;
    }

    public SqlParameter(int sqlType, int scale) {
        this.sqlType = sqlType;
        this.scale = new Integer(scale);
    }

    public SqlParameter(String name2, int sqlType) {
        this.name = name2;
        this.sqlType = sqlType;
    }

    public SqlParameter(String name2, int sqlType, String typeName) {
        this.name = name2;
        this.sqlType = sqlType;
        this.typeName = typeName;
    }

    public SqlParameter(String name2, int sqlType, int scale) {
        this.name = name2;
        this.sqlType = sqlType;
        this.scale = new Integer(scale);
    }

    public SqlParameter(SqlParameter otherParam) {
        Assert.notNull(otherParam, "SqlParameter object must not be null");
        this.name = otherParam.name;
        this.sqlType = otherParam.sqlType;
        this.typeName = otherParam.typeName;
        this.scale = otherParam.scale;
    }

    public String getName() {
        return this.name;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Integer getScale() {
        return this.scale;
    }

    public boolean isInputValueProvided() {
        return true;
    }

    public boolean isResultsParameter() {
        return false;
    }

    public static List sqlTypesToAnonymousParameterList(int[] types) {
        LinkedList<SqlParameter> result2 = new LinkedList<SqlParameter>();
        if (types != null) {
            for (int i = 0; i < types.length; ++i) {
                result2.add(new SqlParameter(types[i]));
            }
        }
        return result2;
    }
}

