/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;

public class CachingMetadataReaderFactory
extends SimpleMetadataReaderFactory {
    private final Map<Resource, MetadataReader> classReaderCache = new HashMap<Resource, MetadataReader>();

    public CachingMetadataReaderFactory() {
    }

    public CachingMetadataReaderFactory(ResourceLoader resourceLoader) {
        super(resourceLoader);
    }

    public CachingMetadataReaderFactory(ClassLoader classLoader) {
        super(classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataReader getMetadataReader(Resource resource) throws IOException {
        Map<Resource, MetadataReader> map2 = this.classReaderCache;
        synchronized (map2) {
            MetadataReader metadataReader = this.classReaderCache.get(resource);
            if (metadataReader == null) {
                metadataReader = super.getMetadataReader(resource);
                this.classReaderCache.put(resource, metadataReader);
            }
            return metadataReader;
        }
    }
}

