/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.core.AliasRegistry;
import org.springframework.core.CollectionFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

public class SimpleAliasRegistry
implements AliasRegistry {
    private final Map aliasMap = CollectionFactory.createConcurrentMapIfPossible(16);

    public void registerAlias(String name2, String alias) {
        Assert.hasText(name2, "'name' must not be empty");
        Assert.hasText(alias, "'alias' must not be empty");
        if (alias.equals(name2)) {
            this.aliasMap.remove(alias);
        } else {
            String registeredName;
            if (!this.allowAliasOverriding() && (registeredName = (String)this.aliasMap.get(alias)) != null && !registeredName.equals(name2)) {
                throw new IllegalStateException("Cannot register alias '" + alias + "' for name '" + name2 + "': It is already registered for name '" + registeredName + "'.");
            }
            this.aliasMap.put(alias, name2);
        }
    }

    protected boolean allowAliasOverriding() {
        return true;
    }

    public void removeAlias(String alias) {
        String name2 = (String)this.aliasMap.remove(alias);
        if (name2 == null) {
            throw new IllegalStateException("No alias '" + alias + "' registered");
        }
    }

    public boolean isAlias(String name2) {
        return this.aliasMap.containsKey(name2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAliases(String name2) {
        ArrayList aliases = new ArrayList();
        Map map2 = this.aliasMap;
        synchronized (map2) {
            Iterator it = this.aliasMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String registeredName = (String)entry.getValue();
                if (!registeredName.equals(name2)) continue;
                aliases.add(entry.getKey());
            }
        }
        return StringUtils.toStringArray(aliases);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveAliases(StringValueResolver valueResolver) {
        Assert.notNull(valueResolver, "StringValueResolver must not be null");
        Map map2 = this.aliasMap;
        synchronized (map2) {
            HashMap aliasCopy = new HashMap(this.aliasMap);
            Iterator it = aliasCopy.keySet().iterator();
            while (it.hasNext()) {
                String alias = (String)it.next();
                String registeredName = (String)aliasCopy.get(alias);
                String resolvedAlias = valueResolver.resolveStringValue(alias);
                String resolvedName = valueResolver.resolveStringValue(registeredName);
                if (!resolvedAlias.equals(alias)) {
                    String existingName = (String)this.aliasMap.get(resolvedAlias);
                    if (existingName != null && !existingName.equals(resolvedName)) {
                        throw new IllegalStateException("Cannot register resolved alias '" + resolvedAlias + "' (original: '" + alias + "') for name '" + resolvedName + "': It is already registered for name '" + registeredName + "'.");
                    }
                    this.aliasMap.put(resolvedAlias, resolvedName);
                    this.aliasMap.remove(alias);
                    continue;
                }
                if (registeredName.equals(resolvedName)) continue;
                this.aliasMap.put(alias, resolvedName);
            }
        }
    }

    public String canonicalName(String name2) {
        String canonicalName = name2;
        String resolvedName = null;
        do {
            if ((resolvedName = (String)this.aliasMap.get(canonicalName)) == null) continue;
            canonicalName = resolvedName;
        } while (resolvedName != null);
        return canonicalName;
    }
}

