/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.springframework.core.ConstantException;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class Constants {
    private final String className;
    private final Map fieldCache = new HashMap();

    public Constants(Class clazz) {
        Assert.notNull(clazz);
        this.className = clazz.getName();
        Field[] fields = clazz.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field2 = fields[i];
            if (!ReflectionUtils.isPublicStaticFinal(field2)) continue;
            String name2 = field2.getName();
            try {
                Object value = field2.get(null);
                this.fieldCache.put(name2, value);
                continue;
            }
            catch (IllegalAccessException ex) {
                // empty catch block
            }
        }
    }

    public final String getClassName() {
        return this.className;
    }

    public final int getSize() {
        return this.fieldCache.size();
    }

    protected final Map getFieldCache() {
        return this.fieldCache;
    }

    public Number asNumber(String code) throws ConstantException {
        Object obj = this.asObject(code);
        if (!(obj instanceof Number)) {
            throw new ConstantException(this.className, code, "not a Number");
        }
        return (Number)obj;
    }

    public String asString(String code) throws ConstantException {
        return this.asObject(code).toString();
    }

    public Object asObject(String code) throws ConstantException {
        Assert.notNull(code, "Code must not be null");
        String codeToUse = code.toUpperCase(Locale.ENGLISH);
        Object val = this.fieldCache.get(codeToUse);
        if (val == null) {
            throw new ConstantException(this.className, codeToUse, "not found");
        }
        return val;
    }

    public Set getNames(String namePrefix) {
        String prefixToUse = namePrefix != null ? namePrefix.trim().toUpperCase(Locale.ENGLISH) : "";
        HashSet<String> names2 = new HashSet<String>();
        Iterator it = this.fieldCache.keySet().iterator();
        while (it.hasNext()) {
            String code = (String)it.next();
            if (!code.startsWith(prefixToUse)) continue;
            names2.add(code);
        }
        return names2;
    }

    public Set getNamesForProperty(String propertyName) {
        return this.getNames(this.propertyToConstantNamePrefix(propertyName));
    }

    public Set getNamesForSuffix(String nameSuffix) {
        String suffixToUse = nameSuffix != null ? nameSuffix.trim().toUpperCase(Locale.ENGLISH) : "";
        HashSet<String> names2 = new HashSet<String>();
        Iterator it = this.fieldCache.keySet().iterator();
        while (it.hasNext()) {
            String code = (String)it.next();
            if (!code.endsWith(suffixToUse)) continue;
            names2.add(code);
        }
        return names2;
    }

    public Set getValues(String namePrefix) {
        String prefixToUse = namePrefix != null ? namePrefix.trim().toUpperCase(Locale.ENGLISH) : "";
        HashSet values = new HashSet();
        Iterator it = this.fieldCache.keySet().iterator();
        while (it.hasNext()) {
            String code = (String)it.next();
            if (!code.startsWith(prefixToUse)) continue;
            values.add(this.fieldCache.get(code));
        }
        return values;
    }

    public Set getValuesForProperty(String propertyName) {
        return this.getValues(this.propertyToConstantNamePrefix(propertyName));
    }

    public Set getValuesForSuffix(String nameSuffix) {
        String suffixToUse = nameSuffix != null ? nameSuffix.trim().toUpperCase(Locale.ENGLISH) : "";
        HashSet values = new HashSet();
        Iterator it = this.fieldCache.keySet().iterator();
        while (it.hasNext()) {
            String code = (String)it.next();
            if (!code.endsWith(suffixToUse)) continue;
            values.add(this.fieldCache.get(code));
        }
        return values;
    }

    public String toCode(Object value, String namePrefix) throws ConstantException {
        String prefixToUse = namePrefix != null ? namePrefix.trim().toUpperCase(Locale.ENGLISH) : null;
        Iterator it = this.fieldCache.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            if (!key.startsWith(prefixToUse) || !entry.getValue().equals(value)) continue;
            return key;
        }
        throw new ConstantException(this.className, prefixToUse, value);
    }

    public String toCodeForProperty(Object value, String propertyName) throws ConstantException {
        return this.toCode(value, this.propertyToConstantNamePrefix(propertyName));
    }

    public String toCodeForSuffix(Object value, String nameSuffix) throws ConstantException {
        String suffixToUse = nameSuffix != null ? nameSuffix.trim().toUpperCase(Locale.ENGLISH) : null;
        Iterator it = this.fieldCache.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            if (!key.endsWith(suffixToUse) || !entry.getValue().equals(value)) continue;
            return key;
        }
        throw new ConstantException(this.className, suffixToUse, value);
    }

    public String propertyToConstantNamePrefix(String propertyName) {
        StringBuffer parsedPrefix = new StringBuffer();
        for (int i = 0; i < propertyName.length(); ++i) {
            char c = propertyName.charAt(i);
            if (Character.isUpperCase(c)) {
                parsedPrefix.append("_");
                parsedPrefix.append(c);
                continue;
            }
            parsedPrefix.append(Character.toUpperCase(c));
        }
        return parsedPrefix.toString();
    }
}

