/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.ConcurrentMap;
import org.springframework.core.JdkVersion;
import org.springframework.util.ClassUtils;

public abstract class CollectionFactory {
    private static final Log logger = LogFactory.getLog(CollectionFactory.class);
    private static final boolean commonsCollections3Available = ClassUtils.isPresent("org.apache.commons.collections.map.CaseInsensitiveMap", CollectionFactory.class.getClassLoader());
    private static final boolean backportConcurrentAvailable = ClassUtils.isPresent("edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap", CollectionFactory.class.getClassLoader());
    private static final Set approximableCollectionTypes = new HashSet(10);
    private static final Set approximableMapTypes = new HashSet(6);

    public static Set createLinkedSetIfPossible(int initialCapacity) {
        return new LinkedHashSet(initialCapacity);
    }

    public static Set createCopyOnWriteSet() {
        if (JdkVersion.isAtLeastJava15()) {
            logger.trace("Creating [java.util.concurrent.CopyOnWriteArraySet]");
            return JdkConcurrentCollectionFactory.createCopyOnWriteArraySet();
        }
        if (backportConcurrentAvailable) {
            logger.trace("Creating [edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArraySet]");
            return BackportConcurrentCollectionFactory.createCopyOnWriteArraySet();
        }
        throw new IllegalStateException("Cannot create CopyOnWriteArraySet - neither JDK 1.5 nor backport-concurrent available on the classpath");
    }

    public static Map createLinkedMapIfPossible(int initialCapacity) {
        return new LinkedHashMap(initialCapacity);
    }

    public static Map createLinkedCaseInsensitiveMapIfPossible(int initialCapacity) {
        if (commonsCollections3Available) {
            logger.trace("Creating [org.apache.commons.collections.map.ListOrderedMap/CaseInsensitiveMap]");
            return CommonsCollectionFactory.createListOrderedCaseInsensitiveMap(initialCapacity);
        }
        logger.debug("Falling back to [java.util.LinkedHashMap] for linked case-insensitive map");
        return new LinkedHashMap(initialCapacity);
    }

    public static Map createIdentityMapIfPossible(int initialCapacity) {
        return new IdentityHashMap(initialCapacity);
    }

    public static Map createConcurrentMapIfPossible(int initialCapacity) {
        if (JdkVersion.isAtLeastJava15()) {
            logger.trace("Creating [java.util.concurrent.ConcurrentHashMap]");
            return JdkConcurrentCollectionFactory.createConcurrentHashMap(initialCapacity);
        }
        if (backportConcurrentAvailable) {
            logger.trace("Creating [edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap]");
            return BackportConcurrentCollectionFactory.createConcurrentHashMap(initialCapacity);
        }
        logger.debug("Falling back to plain synchronized [java.util.HashMap] for concurrent map");
        return Collections.synchronizedMap(new HashMap(initialCapacity));
    }

    public static ConcurrentMap createConcurrentMap(int initialCapacity) {
        if (JdkVersion.isAtLeastJava15()) {
            logger.trace("Creating [java.util.concurrent.ConcurrentHashMap]");
            return new JdkConcurrentHashMap(initialCapacity);
        }
        if (backportConcurrentAvailable) {
            logger.trace("Creating [edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap]");
            return new BackportConcurrentHashMap(initialCapacity);
        }
        throw new IllegalStateException("Cannot create ConcurrentHashMap - neither JDK 1.5 nor backport-concurrent available on the classpath");
    }

    public static boolean isApproximableCollectionType(Class collectionType) {
        return collectionType != null && approximableCollectionTypes.contains(collectionType);
    }

    public static Collection createApproximateCollection(Object collection, int initialCapacity) {
        if (collection instanceof LinkedList) {
            return new LinkedList();
        }
        if (collection instanceof List) {
            return new ArrayList(initialCapacity);
        }
        if (collection instanceof SortedSet) {
            return new TreeSet(((SortedSet)collection).comparator());
        }
        return new LinkedHashSet(initialCapacity);
    }

    public static boolean isApproximableMapType(Class mapType) {
        return mapType != null && approximableMapTypes.contains(mapType);
    }

    public static Map createApproximateMap(Object map2, int initialCapacity) {
        if (map2 instanceof SortedMap) {
            return new TreeMap(((SortedMap)map2).comparator());
        }
        return new LinkedHashMap(initialCapacity);
    }

    static {
        approximableCollectionTypes.add(Collection.class);
        approximableCollectionTypes.add(List.class);
        approximableCollectionTypes.add(Set.class);
        approximableCollectionTypes.add(SortedSet.class);
        approximableMapTypes.add(Map.class);
        approximableMapTypes.add(SortedMap.class);
        if (JdkVersion.isAtLeastJava16()) {
            approximableCollectionTypes.add(NavigableSet.class);
            approximableMapTypes.add(NavigableMap.class);
        }
        approximableCollectionTypes.add(ArrayList.class);
        approximableCollectionTypes.add(LinkedList.class);
        approximableCollectionTypes.add(HashSet.class);
        approximableCollectionTypes.add(LinkedHashSet.class);
        approximableCollectionTypes.add(TreeSet.class);
        approximableMapTypes.add(HashMap.class);
        approximableMapTypes.add(LinkedHashMap.class);
        approximableMapTypes.add(TreeMap.class);
    }

    private static class BackportConcurrentHashMap
    extends ConcurrentHashMap
    implements ConcurrentMap {
        public BackportConcurrentHashMap(int initialCapacity) {
            super(initialCapacity);
        }
    }

    private static class JdkConcurrentHashMap
    extends java.util.concurrent.ConcurrentHashMap
    implements ConcurrentMap {
        public JdkConcurrentHashMap(int initialCapacity) {
            super(initialCapacity);
        }
    }

    private static abstract class BackportConcurrentCollectionFactory {
        private BackportConcurrentCollectionFactory() {
        }

        private static Set createCopyOnWriteArraySet() {
            return new edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArraySet();
        }

        private static Map createConcurrentHashMap(int initialCapacity) {
            return new ConcurrentHashMap(initialCapacity);
        }
    }

    private static abstract class JdkConcurrentCollectionFactory {
        private JdkConcurrentCollectionFactory() {
        }

        private static Set createCopyOnWriteArraySet() {
            return new CopyOnWriteArraySet();
        }

        private static Map createConcurrentHashMap(int initialCapacity) {
            return new java.util.concurrent.ConcurrentHashMap(initialCapacity);
        }
    }

    private static abstract class CommonsCollectionFactory {
        private CommonsCollectionFactory() {
        }

        private static Map createListOrderedCaseInsensitiveMap(int initialCapacity) {
            return ListOrderedMap.decorate(new CaseInsensitiveMap(initialCapacity == 0 ? 1 : initialCapacity));
        }
    }
}

