/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.core.AttributeAccessor;
import org.springframework.util.Assert;

public abstract class AttributeAccessorSupport
implements AttributeAccessor,
Serializable {
    private final Map attributes = new LinkedHashMap();

    public void setAttribute(String name2, Object value) {
        Assert.notNull(name2, "Name must not be null");
        if (value != null) {
            this.attributes.put(name2, value);
        } else {
            this.removeAttribute(name2);
        }
    }

    public Object getAttribute(String name2) {
        Assert.notNull(name2, "Name must not be null");
        return this.attributes.get(name2);
    }

    public Object removeAttribute(String name2) {
        Assert.notNull(name2, "Name must not be null");
        return this.attributes.remove(name2);
    }

    public boolean hasAttribute(String name2) {
        Assert.notNull(name2, "Name must not be null");
        return this.attributes.containsKey(name2);
    }

    public String[] attributeNames() {
        Set attributeNames = this.attributes.keySet();
        return attributeNames.toArray(new String[attributeNames.size()]);
    }

    protected void copyAttributesFrom(AttributeAccessor source) {
        Assert.notNull(source, "Source must not be null");
        String[] attributeNames = source.attributeNames();
        for (int i = 0; i < attributeNames.length; ++i) {
            String attributeName = attributeNames[i];
            this.setAttribute(attributeName, source.getAttribute(attributeName));
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AttributeAccessorSupport)) {
            return false;
        }
        AttributeAccessorSupport that = (AttributeAccessorSupport)other;
        return ((Object)this.attributes).equals(that.attributes);
    }

    public int hashCode() {
        return ((Object)this.attributes).hashCode();
    }
}

