/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.IOException;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceEditor;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class FileEditor
extends PropertyEditorSupport {
    private final ResourceEditor resourceEditor;

    public FileEditor() {
        this.resourceEditor = new ResourceEditor();
    }

    public FileEditor(ResourceEditor resourceEditor) {
        Assert.notNull(resourceEditor, "ResourceEditor must not be null");
        this.resourceEditor = resourceEditor;
    }

    public void setAsText(String text2) throws IllegalArgumentException {
        File file;
        if (StringUtils.hasText(text2) && !ResourceUtils.isUrl(text2) && (file = new File(text2)).isAbsolute()) {
            this.setValue(file);
            return;
        }
        this.resourceEditor.setAsText(text2);
        Resource resource = (Resource)this.resourceEditor.getValue();
        if (ResourceUtils.isUrl(text2) || resource.exists()) {
            try {
                this.setValue(resource != null ? resource.getFile() : null);
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Could not retrieve File for " + resource + ": " + ex.getMessage());
            }
        } else {
            File file2 = new File(text2);
            this.setValue(file2);
        }
    }

    public String getAsText() {
        File value = (File)this.getValue();
        return value != null ? value.getPath() : "";
    }
}

